//+-------------------------------------------------------------------+
//|                                                       Graeme.mq4  |
//|                                  Copyright  2009, Steve Hopwood  |
//|                              http://www.hopwood3.freeserve.co.uk  |
//+-------------------------------------------------------------------+
#property copyright "Copyright  2009, Steve Hopwood"
#property link      "http://www.hopwood3.freeserve.co.uk"
#include <WinUser32.mqh>
#include <stdlib.mqh>
#define  NL    "\n"
#define  up "Up"
#define  down "Down"
#define  none "None"
#define  both "Both"
#define  buy "Buy"
#define  sell "Sell"
#define  ranging "Ranging"
#define  confused "Confused, and so cannot trade"
#define  trending "Trending"
#define  nomasterinuse "No master trend is being used"

//Pending trade price line
#define  pendingpriceline "Pending price line"
//Hidden sl and tp lines. If UseStealth enabled, the bot will close trades on a touch/break of these lines.
//Each line is named with its appropriate prefix and the ticket number of the relevant trade
#define  TpPrefix "Tp"
#define  SlPrefix "Sl"


//Caterpillar
#define  buyline "Buy line"
#define  sellline "Sell line"

//Defined constants from hanover. Thanks David
#define AUD 0
#define CAD 1
#define CHF 2
#define EUR 3
#define GBP 4
#define JPY 5
#define NZD 6
#define USD 7

#define M1  0
#define M5  1
#define M15 2
#define M30 3
#define H1  4
#define H4  5
#define D1  6
#define W1  7
#define MN  8

/*

This EA automates the trading system described at http://www.forexfactory.com/showthread.php?p=3899196#post3899196
I have named it after PipEasy, whose name is Graeme.
Tweaks to the system are:
   - trade only in the direction of the trend as identified by the panoply of trend-detection functions
   - set a jumping stop every 100 pips

Matt Kennel has provided the code for bool O_R_CheckForHistory(int ticket). Cheers Matt, You are a star.
TIG has provided the code for round/big number detection. Cheers George. You are a star.

Code from George, to detect the shift of an order open time
bar = iBarShift(NULL,Period(),OrderOpenTime(), false);

Code for adding debugging Sleep
Alert("G");
int x = 0;
while (x == 0) Sleep(100);

Code for returning a value as pips. The example returns the range of the previous candle
   int PipDivisor = 1;
   if (Digits == 3 || Digits == 5) PipDivisor = 10;
   double CandleRange = ((High[1] - Low[1]) / Point) / PipDivisor;

Standard order loop code
   for (int cc = OrdersTotal() - 1; cc >= 0; cc--)
   {
      if (!OrderSelect(cc, SELECT_BY_POS) ) continue;
      if (OrderSymbol() != Symbol() ) continue;
      if (OrderMagicNumber() != MagicNumber) continue;

   }//for (int cc = OrdersTotal() - 1; cc >= 0; cc--)


FUNCTIONS LIST
void DisplayUserFeedback()
int init()
int start()

----Trading----

void LookForTradingOpportunities()
   void HasBuyFilled()
   void HasSellFilled()
   bool IsTradingAllowed()
   double CalculateLotSize(double price1, double price2)
bool SendSingleTrade(int type, string comment, double lotsize, double price, double stop, double take)
   void ModifyOrder(int ticket, double stop, double take)
void CountOpenTrades()
   void InsertStopLoss(int ticket)
   void InsertTakeProfit(int ticket)
bool CloseTrade(int ticket)
bool LookForTradeClosure(int ticket)
bool CheckTradingTimes()
void CloseAllTrades()
double CalculateTradeProfitInPips()

----Hidden sl/tp---- Doubles up for pending trades-based ea's
void DrawPendingPriceLines()
void DeletePendingPriceLines()
void ReplaceMissingSlTpLines()
void DeleteOrphanTpSlLines()

----Balance/swap filters module----
void TradeDirectionBySwap()
bool IsThisPairTradable()
bool BalancedPair(int type)

----Matt's Order Reliable library code
bool O_R_CheckForHistory(int ticket) Cheers Matt, You are a star.
void O_R_Sleep(double mean_time, double max_time)

----Indicator readings----
void ReadIndicatorValues()
void GetBB(int shift)
double GetRsi(int tf, int period, int ap, int shift)
double GetMa(int tf, int period, int mashift, int method, int ap, int shift)
double CalculateVolatility(int period, int LookBack)
double GetAa(int tf, int price, int period, int mashift, int method, int buffer, int shift)
void CalculateDailyResult()

----Round numbers module---- This code from TIG. Cheers George, you are a star
void GetNextRoundNumbers()
   double GetNext00(double price) {
   double GetPrev00(double price) {
   double GetNext000(double price) {
   double GetPrev000(double price) {

----Trend detection module----
void TrendDetectionModule()

----Hanover module----
bool HanoverFilter(int type)
void SetUpArrays()
void CleanUpInputString()
int CalculateParamsPassed()
void ReadHanover()
int LoadRSvalues()  
double ReadStrength(string curr, string tf, int shift)

----Central Bank Intervention module----
bool CentralBankInterventionModule()
void StoreQuote()
bool CbiHedging(int type)
bool SetupHedgeTrade(int type, string comment, double lotsize, double price)
bool CbiCloseTrades(int type)


//Caterpillar
void StartCaterpillar()
void LookForCatTradingOpportunities()
void DeleteOrphanGlobals()



----Recovery----
void RecoveryModule()
void CheckRecoveryTakeProfit()
int Analyze()
int SymbolsIndex(string SymbolName)
void RecoveryCandlesticktrailingStop()
void LockInRecoveryProfit()
void AddReEntryLine(double price)
void CalculateReEntryLinePips() not included yet
void ReplaceReEntryLine()
void RecoveryCandlesticktrailingStop()

----Trade management module----
void TradeManagementModule()
void BreakEvenStopLoss()
void JumpingStopLoss() 
void HiddenTakeProfit()
void HiddenStopLoss()
void TrailingStopLoss()
void CandlestickTrailingStop()
void ReportError()

*/

extern string  gen="----General inputs----";
extern double  Lot=0.02;
extern int     RiskPercent = 0;//Set to zero to disable and use Lot
extern bool    StopTrading=false;
extern bool    TradeLong=true;
extern bool    TradeShort=true;
int     TakeProfit=0;
int     StopLoss=100;//Sets the stop at roughly the previous round number
extern int     MagicNumber=5;
extern string  TradeComment="Graeme";
extern bool    CriminalIsECN=false;
extern double  MaxSpread=120;

//Hidden tp/sl inputs.
extern string  hts="----Stealth stop loss and take profit inputs----";
extern int     HiddenPips=10;//Added to the 'hard' sl and tp and used for closure calculations

//Round/big numbers
extern string  rni="----Round/Big number inputs----";
extern bool    TradeBigNumbers=false;
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
double         RoundNumberLow, RoundNumberHigh, BigNumberLow, BigNumberHigh;
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//Pending price inputs. Keeps things hidden from the crims.
extern string  ppi="----Pending trade inputs----";
extern color   BuyLineColour=Green;
extern color   SellLineColour=Red;
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
int            MinPipsBetweenTrades=90;//To ensure we are not repeatedly opening trades by bouncing around the round number
int            MaxPendingPipsFromMarket=150;//For moving the pending price line
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

extern string  bf="----Trading balance filters----";
extern bool    UseZeljko=false;
extern bool    OnlyTradeCurrencyTwice=false;

extern string  tdm="----Trend detection module----";
extern bool    RisingTrend=false;
extern bool    FallingTrend=false;
extern bool    UseTrendDetection=true;
extern bool    CloseTradesOnTrendChange=true;

//RSI. >55 is trending up. < 45 is trending down
extern string  trsi="Rsi trend detection";
extern bool    UseRsiTrendDetection=true;
extern bool    RsiIsMaster=true;
extern int     RsiTdTf=1440;
extern int     RsiTdPeriod=20;
extern string  trs="Applied price: 0=Close; 1=Open; 2=High";
extern string  trs1="3=Low; 4=Median; 5=Typical; 6=Weighted";
extern int     RsiTdAppliedPrice=0;
extern int     RsiBuffer=3;
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
double         TrendRsiVal;//Rsi
string         RsiTrend;
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//NB V10. D1 candle hi-lo above both ma's: trend is up. Below both: trend is down. In between: market is ranging.
//Also makes an excellent trade trigger in a longer-term trend trading system.
extern string  nbmas="NB V10";
extern bool    UseNanningBobForTrend=false;
extern bool    NanningBobIsMaster=false;
extern int     FastNbTdTF=1440;//Time frame defaults to D1 chart 
extern int     FastNbTdPeriod=2;
extern int     FastNbTdShift=2;//The MA Shift input
extern string  nbmame="Method: 0=sma; 1=ema; 2=smma;  3=lwma";
extern int     FastNbTdMethod=2;
extern string  nbmaap="Applied price: 0=Close; 1=Open; 2=High";
extern string  nbmaap1="3=Low; 4=Median; 5=Typical; 6=Weighted";
extern int     FastNbTdAppliedPrice=4;
extern int     SlowNbTdTF=1440;//Time frame defaults to D1 chart 
extern int     SlowNbTdPeriod=8;
extern int     SlowNbTdMethod=2;
extern int     SlowNbTdShift=2;
extern int     SlowNbTdAppliedPrice=4;
extern int     TrendConfirmationCandleTF=15;//Candle for confirming the trend as a trade trigger
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
double         FastNbTrendMaVal, SlowNbTrendMaVal;//2 MA trend
string         TrendConfirmationCandleDir;//Holds 'up' for an up candle and vice versa
string         TradeTriggerDirection;//For using V10 as a trigger instead of a trend
string         NbTrend;
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//Fast ma > slow, trend is up & vice versa
extern string  tmas="Two MA - 'slowkey'";
extern bool    UseSlowkey=false;
extern bool    SlowkeyIsMaster=false;
extern int     FastMaTdTF=0;//Time frame defaults to current chart 
extern int     FastMaTdPeriod=100;
extern int     FastMaTdShift=0;//The MA Shift input
extern string  tmame="Method: 0=sma; 1=ema; 2=smma;  3=lwma";
extern int     FastMaTdMethod=0;
extern string  tmaap="Applied price: 0=Close; 1=Open; 2=High";
extern string  tmaap1="3=Low; 4=Median; 5=Typical; 6=Weighted";
extern int     FastMaTdAppliedPrice=0;
extern int     SlowMaTdTF=0;//Time frame defaults to current chart 
extern int     SlowMaTdPeriod=200;
extern int     SlowMaTdShift=0;
extern int     SlowMaTdMethod=0;
extern int     SlowMaTdAppliedPrice=0;
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
double         FastTrendMaVal, SlowTrendMaVal;//2 MA trend
string         SlowkeyTrend;
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//Single, much longer term MA. Rising MA the trend is up and vice-versa
extern string  aal="----All averages inputs----";
extern bool    UseAA=false;
extern bool    AaIsMaster=false;
extern int     TimeFrame    =  1440;
extern int     Price        =  0;
extern int     MA_Period    = 50;
extern int     MA_Shift     =  0;
extern int     MA_Method    =  0;
extern int     CandleShift  =  0;
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
double         AaVal, AaUp, AaDown;//Buffers 0 (val) 1 (up) and 3 (down)
string         AaTrend;
bool           CloseOnOppositeSignal;
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

extern string  hm="----Hanover module----";
extern bool    UseHanover=false;
extern string  ctf="Time frames";
//extern string  TimeFrames="M1,M5,M15,M30,H1,H4,D1,W1,MN";
extern string  TimeFrames="D1";
//extern string  SlopeConfirmationCandles="0,0,0,0,0,0,0,0,0";
extern string  SlopeConfirmationCandles="0";
extern int     StrongThreshold=0;
extern int     WeakThreshold=0;
extern string  hof="Hanover output file";
extern string  OutputFile            = "Output---Recent Strength.CSV";
extern int     NumPoints=15;
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Arrays etc
string         InputString;//All purpose string to pass to CleanUpInputString() to remove unwanted leading/trailing stuff
int            NoOfTimeFrames;//The number for timeframes inputted into the TimeFrames input
string         Tf[];//Holds the time frames inputted into the TimeFrames input
string         StrongWeak[];//Holds the pair that represents the strongest and weakest in each time frame
string         StrongestCcy[], WeakestCcy[];//Go on, take a guess
double         StrongVal[], PrevStrongVal[], WeakVal[], PrevWeakVal[];//Another guess?
string         ConstructedPair[];//Holds the pairs made out of the currencies
int            SlopeCandles[];//Holds the slope confirmation candles specified in SlopeConfirmationCandles input
string         Ccy1, Ccy2;//First and second currency in the pair

//Variables copied from the Strength Alerts indi. int LoadRSvalues() came from this
int      dig, tmf, h, i, j, k;
string alrt[11];
double   RSvalue[8,9,99];   // [currency,timeframe,datapoint#]
                            // currency: 0=AUD, 1=CAD, 2=CHF, 3=EUR, 4=GBP, 5=JPY, 6=NZD, 7=USD
                            // timeframe: 0=M1, 1=M5, 2=M15, 3=M30, 4=H1, 5=H4, 6=D1, 7=W1, 8=MN
                         
string   ccy[8] = {"AUD","CAD","CHF","EUR","GBP","JPY","NZD","USD"};
string   tf[9]  = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"};
string   arr[11];

int      ReadBars;//Bot reads the output file when this != Bars   
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

extern string  cbi="----Central Bank Intervention module----";
extern bool    UseCBI=false;
extern int     TableSize=20;
extern int     Threshold=10;
extern bool    CloseOnCBI=false;
extern bool    HedgeOnCBI=true;
extern double  CbiHedgeLotMultiplier=4;
extern bool    TradeOnCBI=true;
extern int     TradeOnCbiTP=200;//Take profit
extern int     TradeOnCbiSL=50;//Stoploss
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
double         TickTable[20]; // circular buffer to hold the ticks
int            tc = 0; // Tick counter. current position in table
int            is_filled = 0; // is the table full yet?
int            fill_check_counter = 0; // check if we have looped through the table once
double         PipMultiplier = 1.0; // needed to convert a price differenct into a pip value
double         TickDiff;//Difference between current quote and TableSize quotes ago
//Some Booleans to tell the bot what it has already done
bool           TakingEmergencyAction;//Will be true if TickDiff crosses the threshold
bool           TradeSent, HedgeSent, TradesClosed;
bool           HedgingInProgress;//So the bot knows it is dealing with a hedged situation
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

extern string  amc="----Available Margin checks----";
extern string  sco="Scoobs";
extern bool    UseScoobsMarginCheck=false;
extern string  fk="ForexKiwi";
extern bool    UseForexKiwi=true;
extern int     FkMinimumMarginPercent=1500;
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
bool           EnoughMargin;
string         MarginMessage;
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


extern string  tt="----Trading hours----";
extern string  Trade_Hours= "Set Morning & Evening Hours";
extern string  Trade_Hoursi= "Use 24 hour, local time clock";
extern string  Trade_Hours_M= "Morning Hours 0-12";
extern  int    start_hourm = 0;
extern  int    end_hourm = 12;
extern string  Trade_Hours_E= "Evening Hours 12-24";
extern  int    start_houre = 12;
extern  int    end_houre = 24;

extern string  pts="----Swap filter----";
extern bool    CadPairsPositiveOnly=false;
extern bool    AudPairsPositiveOnly=false;
extern bool    NzdPairsPositiveOnly=false;

extern string  tmm="----Trade management module----";
string  BE="Break even settings";
extern int     BreakEvenProfit=10;

extern string  cts="----Candlestick trailing stop----";
extern bool    UseCandlestickTrailingStop=false;
extern int     CstTimeFrame=1440;
extern int     CstTrailCandles=1;//Defaults to previous candle
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
int            OldCstBars;//For candlestick ts
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

extern string  JSL="Jumping stop loss settings";
extern bool    JumpingStop=true;
extern int     JumpingStopPips=100;
extern bool    AddBEP=true;
extern string  TSL="Trailing stop loss settings";
extern bool    TrailingStop=false;
extern int     TrailingStopPips=20;

extern string  mis="----Odds and ends----";
extern bool    ShowManagementAlerts=true;
extern int     DisplayGapSize=30;


//Matt's O-R stuff
int 	         O_R_Setting_max_retries 	= 10;
double 	      O_R_Setting_sleep_time 		= 4.0; /* seconds */
double 	      O_R_Setting_sleep_max 		= 15.0; /* seconds */
int            RetryCount = 10;//Will make this number of attempts to get around the trade context busy error.

//Trading variables
int            TicketNo = -1, OpenTrades;
bool           CanTradeThisPair;//Will be false when this pair fails the currency can only trade twice filter, or the balanced trade filter
bool           BuyOpen, SellOpen, PendingBuyOpen, PendingSellOpen;//Might need further refinement to reflect the pending type
double         upl;//For keeping track of the upl of hedged positions

//Pending price inputs. Keeps things hidden from the crims
bool           PendingBuy, PendingSell;
double         PendingPrice, PendingStop, PendingTake;
datetime       PendingTime;
double         PendingCandleRange;
double         PendingRecreationCancelPips = 2;
//Hidden stops variables
double         HiddenStopLoss, HiddenTakeProfit;


//Trend detection. Any combination of the trends in the inputs list can be combined to generate this OverallTrend
string         OverallTrend;

//Running total of trades
int            LossTrades, WinTrades;
double         OverallProfit;
bool           TradeOpenInThisBand;//Tells G not to trade the current band because there is a trade already open


//TP adjustments, to ensure the tp is at the appropriate round number, and not too close
double         TpAdjustment=100;//To find the next round number for the tp, if the existing is too close
double         MinTp=50;

//Misc
string         Gap, ScreenMessage;
int            OldBars;
string         PipDescription=" pips";
bool           ForceTradeClosure;
int            TurnOff=0;//For turning off functions without removing their code



void DisplayUserFeedback()
{
   
   if (IsTesting() && !IsVisualMode()) return;

   ScreenMessage = "";
   ScreenMessage = StringConcatenate(ScreenMessage,Gap, NL);
   ScreenMessage = StringConcatenate(ScreenMessage,Gap, "Updates for this EA are to be found at http://www.stevehopwoodforex.com", NL);
   ScreenMessage = StringConcatenate(ScreenMessage,Gap, "Feeling generous? Help keep the coder going with a small Paypal donation to pianodoodler@hotmail.com", NL);
   ScreenMessage = StringConcatenate(ScreenMessage, Gap, TimeToStr(TimeLocal(), TIME_DATE|TIME_MINUTES|TIME_SECONDS), NL );
   /*
   //Code for time to bar-end display from Candle Time by Nick Bilak
   double i;
   int m,s,k;
   m=Time[0]+Period()*60-CurTime();
   i=m/60.0;
   s=m%60;
   m=(m-m%60)/60;
   ScreenMessage = StringConcatenate(ScreenMessage,Gap, m + " minutes " + s + " seconds left to bar end", NL);
   */
      
   ScreenMessage = StringConcatenate(ScreenMessage,Gap, NL);      
   if (TradeLong) ScreenMessage = StringConcatenate(ScreenMessage,Gap, "Taking long trades", NL);
   if (TradeShort) ScreenMessage = StringConcatenate(ScreenMessage,Gap, "Taking short trades", NL);
   if (!TradeLong && !TradeShort) ScreenMessage = StringConcatenate(ScreenMessage,Gap, "Both TradeLong and TradeShort are set to false", NL);
   ScreenMessage = StringConcatenate(ScreenMessage,Gap, "Lot size: ", Lot, " (Criminal's minimum lot size: ", MarketInfo(Symbol(), MODE_MINLOT), ")", NL);
   ScreenMessage = StringConcatenate(ScreenMessage,Gap, "Take profit: ", TakeProfit, PipDescription,  NL);
   //ScreenMessage = StringConcatenate(ScreenMessage,Gap, "Stop loss: ", StopLoss, PipDescription,  NL);
   ScreenMessage = StringConcatenate(ScreenMessage,Gap, "Magic number: ", MagicNumber, NL);
   ScreenMessage = StringConcatenate(ScreenMessage,Gap, "Trade comment: ", TradeComment, NL);
   if (CriminalIsECN) ScreenMessage = StringConcatenate(ScreenMessage,Gap, "CriminalIsECN = true", NL);
   else ScreenMessage = StringConcatenate(ScreenMessage,Gap, "CriminalIsECN = false", NL);
   ScreenMessage = StringConcatenate(ScreenMessage,Gap, "MaxSpread = ", MaxSpread, ": Spread = ", MarketInfo(Symbol(), MODE_SPREAD), NL);
   
   ScreenMessage = StringConcatenate(ScreenMessage,Gap, NL);
   ScreenMessage = StringConcatenate(ScreenMessage, Gap, "Next high round number = ", DoubleToStr(RoundNumberHigh, Digits));
   ScreenMessage = StringConcatenate(ScreenMessage, " Next low round number = ", DoubleToStr(RoundNumberLow, Digits), NL);
   ScreenMessage = StringConcatenate(ScreenMessage, Gap, "Next high big number = ", DoubleToStr(BigNumberHigh, Digits));
   ScreenMessage = StringConcatenate(ScreenMessage, " Next low big number = ", DoubleToStr(BigNumberLow, Digits), NL);
   if (TradeBigNumbers) ScreenMessage = StringConcatenate(ScreenMessage,Gap, "Trading the Big numbers", NL);
   else ScreenMessage = StringConcatenate(ScreenMessage,Gap, "Not trading the Big numbers", NL);

   ScreenMessage = StringConcatenate(ScreenMessage,Gap, NL);
   ScreenMessage = StringConcatenate(ScreenMessage,Gap, "Trading hours", NL);
   if (start_hourm == 0 && end_hourm == 12 && start_houre && end_houre == 24) ScreenMessage = StringConcatenate(ScreenMessage,Gap, "            24H trading", NL);
   else
   {
      ScreenMessage = StringConcatenate(ScreenMessage,Gap, "            start_hourm: ", DoubleToStr(start_hourm, 2), 
                      ": end_hourm: ", DoubleToStr(end_hourm, 2), NL);
      ScreenMessage = StringConcatenate(ScreenMessage,Gap, "            start_houre: ", DoubleToStr(start_houre, 2), 
                      ": end_houre: ", DoubleToStr(end_houre, 2), NL);
                      
   }//else
   
   
   //Trend
   ScreenMessage = StringConcatenate(ScreenMessage,Gap, NL);
   if (UseTrendDetection)
   {
      ScreenMessage = StringConcatenate(ScreenMessage,Gap, "Trend is ", OverallTrend, NL);
      //Rsi
      if (UseRsiTrendDetection)
      {
         ScreenMessage = StringConcatenate(ScreenMessage,Gap, "Trend Rsi ", TrendRsiVal, NL);
      }//if (UseRsiTrendDetection)
      
      //slowkey 2 moving average
      if (UseSlowkey)
      {
         ScreenMessage = StringConcatenate(ScreenMessage,Gap, "Fast MA ", FastTrendMaVal, ":  Slow MA ", SlowTrendMaVal,  NL);
      }//if (UseSlowkey)
      
      //Single moving average
      if (UseAA)
      {
         ScreenMessage = StringConcatenate(ScreenMessage,Gap, "AA value ", AaVal, ": AA direction: ", AaTrend, NL);
      }//if (UseAA)
      
      //NB V10
      if (UseNanningBobForTrend)
      {
         ScreenMessage = StringConcatenate(ScreenMessage,Gap, "Fast MA ", FastNbTrendMaVal, ":  Slow MA ", SlowNbTrendMaVal,  NL);      
      }//if (UseNanningBobForTrend)
   
       
       
       
   }//if (UseTrendDetection)
   
   
   if (UseHanover)
   {
      ScreenMessage = StringConcatenate(ScreenMessage,Gap, NL);      
      string now, then;         
      for (int cc = 0; cc < ArraySize(Tf); cc++)
      {
         double strength1 = ReadStrength(Ccy1, Tf[cc], 0);
         double strength2 = ReadStrength(Ccy2, Tf[cc], 0);
         if (SlopeCandles[cc] > 0) 
         {
            double prevstrength1 = ReadStrength(Ccy1, Tf[cc], SlopeCandles[cc]);
            now = StringConcatenate(": Shift ", SlopeCandles[cc], " = ", DoubleToStr(prevstrength1, 2));
            double prevstrength2 = ReadStrength(Ccy2, Tf[cc], SlopeCandles[cc]);
            then = StringConcatenate(": Shift ", SlopeCandles[cc], " = ", DoubleToStr(prevstrength2, 2));
         }//if (SlopeCandles[cc] > 0) 
      
         ScreenMessage = StringConcatenate(ScreenMessage,Gap, "TF ", Tf[cc], 
                                           ": ", Ccy1, ": Now = ", DoubleToStr(strength1, 2),
                                           now,
                                           ": ", Ccy2, ": Now = ", DoubleToStr(strength2, 2),
                                           then,
                                           NL);
      }//for (int cc = 0; cc < ArraySize(Tf); cc++)
      if (StrongThreshold > 0 && WeakThreshold > 0)
      {
         bool tradeable = false;
         if (strength1 > StrongThreshold && strength2 < WeakThreshold)
         {
            ScreenMessage = StringConcatenate(ScreenMessage,Gap, "Threshold: Can trade this pair long", NL);
            tradeable = true;
         }//if (strength1 > StrongThreshold && strength2 < WeakThreshold)
         
         if (strength2 > StrongThreshold && strength1 < WeakThreshold)
         {
            ScreenMessage = StringConcatenate(ScreenMessage,Gap, "Threshold: Can trade this pair short", NL);
            tradeable = true;
         }//if (strength1 > StrongThreshold && strength2 < WeakThreshold)
         
         if (!tradeable) ScreenMessage = StringConcatenate(ScreenMessage,Gap, "Threshold: Cannot trade this pair yet", NL);
      }//if (StrongThreshold > 0 && WeakThreshold > 0)
      
   }//if (UseHanover)

   
   //Central Bank Intervention
   if (UseCBI)
   {
      ScreenMessage = StringConcatenate(ScreenMessage,Gap, NL);   
      ScreenMessage = StringConcatenate(ScreenMessage,Gap, "Central Bank Intervention", NL);
      string actions = "        ";
      if (TradeOnCBI) actions = StringConcatenate(actions, "Taking new trade: ");
      if (HedgeOnCBI) actions = StringConcatenate(actions, "Hedging existing trades: ");
      if (CloseOnCBI) actions = StringConcatenate(actions, "Closing existing trades: ");
      ScreenMessage = StringConcatenate(ScreenMessage,Gap, actions, NL);
      if (is_filled == 0) // table not full yet, so nothing to do
      { 
         ScreenMessage = StringConcatenate(ScreenMessage,Gap, "        ", "Filling Tick table. ", fill_check_counter, " of ", TableSize, " Ticks filled.");         
      }//if (is_filled == 0)
      else 
      {
         ScreenMessage = StringConcatenate(ScreenMessage,Gap, "        ", "Current tick difference: ", DoubleToStr(TickDiff, 1), ", Threshold: ", Threshold);
      }//else

   }//if (UseCBI)
   
   
   ScreenMessage = StringConcatenate(ScreenMessage,Gap, NL);
   

   if (UseCandlestickTrailingStop)
   {
      ScreenMessage = StringConcatenate(ScreenMessage,Gap, "Using candlestick trailing stop", NL);      
   }//if (UseCandlestickTrailingStop)
   
   if (JumpingStop)
   {
      ScreenMessage = StringConcatenate(ScreenMessage,Gap, "Jumping stop is set to ", JumpingStopPips, PipDescription);
      ScreenMessage = StringConcatenate(ScreenMessage,Gap, NL);   
   }//if (JumpingStop)
   

   if (TrailingStop)
   {
      ScreenMessage = StringConcatenate(ScreenMessage,Gap, "Trailing stop is set to ", TrailingStopPips, PipDescription);
      ScreenMessage = StringConcatenate(ScreenMessage,Gap, NL);   
   }//if (TrailingStop)


   //ScreenMessage = StringConcatenate(ScreenMessage,Gap, "BB Upper line: ", DoubleToStr(BbUpper, Digits), NL);
   //ScreenMessage = StringConcatenate(ScreenMessage,Gap, "BB Middle line: ", DoubleToStr(BbMiddle, Digits), NL);
   //ScreenMessage = StringConcatenate(ScreenMessage,Gap, "BB Lower line: ", DoubleToStr(BbLower, Digits), NL);
   //ScreenMessage = StringConcatenate(ScreenMessage,Gap, "BB Lower line: ", DoubleToStr(BbLower, Digits), NL);
   
   if (MarginMessage != "") ScreenMessage = StringConcatenate(ScreenMessage,NL, Gap, MarginMessage, NL);

   
   Comment(ScreenMessage);


}//void DisplayUserFeedback()


//+------------------------------------------------------------------+
//| expert initialization function                                   |
//+------------------------------------------------------------------+
int init()
{
//----

   //Adapt to x digit criminals
   int multiplier;
   if(Digits == 2 || Digits == 4) multiplier = 1;
   if(Digits == 3 || Digits == 5) multiplier = 10;
   if(Digits == 6) multiplier = 100;   
   if(Digits == 7) multiplier = 1000;   
   
   if (multiplier > 1) PipDescription = " points";
   
   TakeProfit*= multiplier;
   StopLoss*= multiplier;
   HiddenPips*= multiplier;
   TradeOnCbiTP*= multiplier;
   TradeOnCbiSL*= multiplier;
   MaxPendingPipsFromMarket*= multiplier;
   MinPipsBetweenTrades*= multiplier;
   TpAdjustment*= multiplier;
   MinTp*= multiplier;
   
   BreakEvenProfit*= multiplier;
   JumpingStopPips*= multiplier;
   TrailingStopPips*= multiplier;
   
   
   Gap="";
   if (DisplayGapSize >0)
   {
      for (int cc=0; cc< DisplayGapSize; cc++)
      {
         Gap = StringConcatenate(Gap, " ");
      }   
   }//if (DisplayGapSize >0)
   
   //Reset CriminIsECN if crim is IBFX and the punter does not know or, like me, keeps on forgetting
   string name = TerminalCompany();
   int ispart = StringFind(name, "IBFX", 0);
   if (ispart < 0) ispart = StringFind(name, "Interbank FX", 0);
   if (ispart > -1) CriminalIsECN = true;   
   
   /////////////////////////////////////////////////////////////////////////////////////////////////////////
   //Hanover module
   //Set up the arrays
   if (UseHanover)
   {
      SetUpArrays();
      Ccy1 = StringSubstr(Symbol(), 0, 3);
      Ccy2 = StringSubstr(Symbol(), 3, 3);
      ReadBars = iBars(NULL, PERIOD_M1);//Don't need it again when start() triggers
      ReadHanover();
   }//if (UseHanover)
   /////////////////////////////////////////////////////////////////////////////////////////////////////////
   
   /////////////////////////////////////////////////////////////////////////////////////////////////////////
   //CBI module
   int ret = ArrayResize(TickTable, TableSize);
   if (ret == -1) {
      Alert("Error: Could not initialize tick table!\n");
   }
   
   if (Digits == 2 || Digits == 3) PipMultiplier = 100.0;
   else if (Digits == 4 || Digits == 5) PipMultiplier = 10000.0;
   /////////////////////////////////////////////////////////////////////////////////////////////////////////
   

   if (TradeComment == "") TradeComment = " ";
   ReadIndicatorValues();//For initial display in case user has turned of constant re-display
   GetNextRoundNumbers();   
   if (UseTrendDetection) TrendDetectionModule();
   DisplayUserFeedback();
   
   //Call sq's show trades indi
   //iCustom(NULL, 0, "SQ_showTrades",Magic, 0,0);

   
//----
   return(0);
}
//+------------------------------------------------------------------+
//| expert deinitialization function                                 |
//+------------------------------------------------------------------+
int deinit()
{
//----
   Comment("");
//----
   return(0);
}

////////////////////////////////////////////////////////////////////////////////////////////////
//TRADE MANAGEMENT MODULE

void ReportError()
{
   //All purpose sl mod error reporter. Called when a sl mod fails
   
   int err=GetLastError();
      
   Alert(OrderTicket()," stop loss modification failed with error(",err,"): ",ErrorDescription(err));
   Print(OrderTicket()," stop loss modification failed with error(",err,"): ",ErrorDescription(err));      

}//void ReportError()



void BreakEvenStopLoss() 
{

   // Move stop loss to breakeven. Called when the market hits the first target
   
   double NewStop;
   bool result;
   bool modify=false;
   string LineName = SlPrefix + DoubleToStr(OrderTicket(), 0);
   double sl = ObjectGet(LineName, OBJPROP_PRICE1);

   if (OrderType()==OP_BUY)
   {
      NewStop = NormalizeDouble(OrderOpenPrice()+(BreakEvenProfit*Point) - (HiddenPips * Point), Digits);         
      modify = true;   
   }//if (OrderType()==OP_BUY)               			         
    
   if (OrderType()==OP_SELL)
   {
      //Calculate the new stop
      NewStop = NormalizeDouble(OrderOpenPrice()-(BreakEvenProfit*Point) + (HiddenPips * Point), Digits);
      modify = true;   
   }//if (OrderType()==OP_SELL)

   //Move 'hard' stop loss whether hidden or not. Don't want to risk losing a breakeven through disconnect.
   if (modify)
   {
      while (IsTradeContextBusy() ) Sleep(100);
      result = OrderModify(OrderTicket(), OrderOpenPrice(), NewStop, OrderTakeProfit(), OrderExpiration(), CLR_NONE);      
      if (!result) 
      {
         ReportError();
         return;
      }//if (!result) 
   }//if (modify)
   
} // End BreakevenStopLoss sub

void JumpingStopLoss() 
{
   // Jump sl by pips and at intervals chosen by user .

   if (OrderProfit() < 0) return;//Nothing to do
   string LineName = SlPrefix + DoubleToStr(OrderTicket(), 0);
   double sl = ObjectGet(LineName, OBJPROP_PRICE1);
   
   //if (sl == 0) return;//No line, so nothing to do
   double NewStop;
   bool modify=false;
   bool result;
   
   
    if (OrderType()==OP_BUY)
    {
       if (sl < OrderOpenPrice() ) return;//Not at breakeven yet
       // Increment sl by sl + JumpingStopPips.
       // This will happen when market price >= (sl + JumpingStopPips)
       //if (Bid>= sl + ((JumpingStopPips*2)*Point) )
       sl = MathMax(sl, OrderOpenPrice());
       if (Bid >=  sl + ((JumpingStopPips * 2) * Point) )//George{
       {
          NewStop = NormalizeDouble(sl + (JumpingStopPips * Point), Digits);
          if (HiddenPips > 0) ObjectMove(LineName, 0, Time[0], NewStop);
          if (NewStop - OrderStopLoss() >= Point) modify = true;//George again. What a guy
       }// if (Bid>= sl + (JumpingStopPips*Point) && sl>= OrderOpenPrice())     
    }//if (OrderType()==OP_BUY)
       
    if (OrderType()==OP_SELL)
    {
       if (sl > OrderOpenPrice() ) return;//Not at breakeven yet
       // Decrement sl by sl - JumpingStopPips.
       // This will happen when market price <= (sl - JumpingStopPips)
       //if (Bid<= sl - ((JumpingStopPips*2)*Point)) Original code
       sl = MathMin(sl, OrderOpenPrice());
       if (sl == 0) sl = OrderOpenPrice();
       if (Bid <= sl - ((JumpingStopPips * 2) * Point) )//George
       {
          NewStop = NormalizeDouble(sl - (JumpingStopPips * Point), Digits);
          if (HiddenPips > 0) ObjectMove(LineName, 0, Time[0], NewStop);
          if (OrderStopLoss() - NewStop >= Point || OrderStopLoss() == 0) modify = true;//George again. What a guy   
       }// close if (Bid>= sl + (JumpingStopPips*Point) && sl>= OrderOpenPrice())         
    }//if (OrderType()==OP_SELL)



   //Move 'hard' stop loss whether hidden or not. Don't want to risk losing a breakeven through disconnect.
   if (modify)
   {
      while (IsTradeContextBusy() ) Sleep(100);
      result = OrderModify(OrderTicket(), OrderOpenPrice(), NewStop, OrderTakeProfit(), OrderExpiration(), CLR_NONE);      
      if (!result) ReportError();      
   }//if (modify)

} //End of JumpingStopLoss sub


void TrailingStopLoss()
{
   
   if (OrderProfit() < 0) return;//Nothing to do
   string LineName = SlPrefix + DoubleToStr(OrderTicket(), 0);
   double sl = ObjectGet(LineName, OBJPROP_PRICE1);
   //if (sl == 0) return;//No line, so nothing to do
   double NewStop;
   bool modify=false;
   bool result;
   
    if (OrderType()==OP_BUY)
       {
          //if (sl < OrderOpenPrice() ) return;//Not at breakeven yet
          // Increment sl by sl + TrailingStopPips.
          // This will happen when market price >= (sl + JumpingStopPips)
          //if (Bid>= sl + (TrailingStopPips * Point) ) Original code
          sl = MathMax(sl, OrderOpenPrice());
          if (Bid >= sl + (TrailingStopPips * Point) )//George
          {
             NewStop = NormalizeDouble(sl + (TrailingStopPips * Point), Digits);
             if (HiddenPips > 0) ObjectMove(LineName, 0, Time[0], NewStop);
             if (NewStop - OrderStopLoss() >= Point) modify = true;//George again. What a guy
          }//if (Bid >= MathMax(sl,OrderOpenPrice()) + (TrailingStopPips * Point) )//George
       }//if (OrderType()==OP_BUY)
       
       if (OrderType()==OP_SELL)
       {
          //if (sl > OrderOpenPrice() ) return;//Not at breakeven yet
          // Decrement sl by sl - TrailingStopPips.
          // This will happen when market price <= (sl - JumpingStopPips)
          //if (Bid<= sl - (TrailingStopPips * Point) ) Original code
          sl = MathMin(sl, OrderOpenPrice());
          if (sl == 0) sl = OrderOpenPrice();
          if (Bid <= sl  - (TrailingStopPips * Point))//George
          {
             NewStop = NormalizeDouble(sl - (TrailingStopPips * Point), Digits);
             if (HiddenPips > 0) ObjectMove(LineName, 0, Time[0], NewStop);
             if (OrderStopLoss() - NewStop >= Point || OrderStopLoss() == 0) modify = true;//George again. What a guy   
          }//if (Bid <= MathMin(sl, OrderOpenPrice() ) - (TrailingStopPips * Point) )//George
       }//if (OrderType()==OP_SELL)


   //Move 'hard' stop loss whether hidden or not. Don't want to risk losing a breakeven through disconnect.
   if (modify)
   {
      while (IsTradeContextBusy() ) Sleep(100);
      result = OrderModify(OrderTicket(), OrderOpenPrice(), NewStop, OrderTakeProfit(), OrderExpiration(), CLR_NONE);      
      if (!result) ReportError();
   }//if (modify)
      
} // End of TrailingStopLoss sub

void CandlestickTrailingStop()
{
   
   //Trails the stop at the hi/lo of the previous candle shifted by the user choice.
   //Only tries to do this once per bar, so an invalid stop error will only be generated once. I could code for
   //a too-close sl, but cannot be arsed. Coders, sort this out for yourselves.
   
   if (OldCstBars == Bars) return;
   OldCstBars = Bars;

   if (OrderProfit() < 0) return;//Nothing to do
   string LineName = SlPrefix + DoubleToStr(OrderTicket(), 0);
   double sl = ObjectGet(LineName, OBJPROP_PRICE1);
   if (sl == 0) return;//No line, so nothing to do
   double NewStop;
   bool modify=false;
   bool result;
   

   if (OrderType() == OP_BUY)
   {
      if (iLow(NULL, CstTimeFrame, CstTrailCandles) > sl && sl > OrderOpenPrice())
      {
         NewStop = NormalizeDouble(Low[1], Digits);
         if (HiddenPips > 0) ObjectMove(LineName, 0, Time[0], NewStop);
         modify = true;   
      }//if (iLow(NULL, CstTimeFrame, CstTrailCandles) > sl)
   }//if (OrderType == OP_BUY)
   
   if (OrderType() == OP_SELL)
   {
      if (iHigh(NULL, CstTimeFrame, CstTrailCandles) < sl && sl < OrderOpenPrice())
      {
         NewStop = NormalizeDouble(High[1], Digits);
         if (HiddenPips > 0) ObjectMove(LineName, 0, Time[0], NewStop);
         modify = true;   
      }//if (iHigh(NULL, CstTimeFrame, CstTrailCandles) < sl)
   }//if (OrderType() == OP_SELL)
   
   //Move 'hard' stop loss whether hidden or not. Don't want to risk losing a breakeven through disconnect.
   if (modify)
   {
      while (IsTradeContextBusy() ) Sleep(100);
      result = OrderModify(OrderTicket(), OrderOpenPrice(), NewStop, OrderTakeProfit(), OrderExpiration(), CLR_NONE);      
      if (!result) ReportError();
   }//if (modify)

}//End void CandlestickTrailingStop()

void TradeManagementModule()
{

   // Call the working subroutines one by one. 

   //Candlestick trailing stop
   if (UseCandlestickTrailingStop) CandlestickTrailingStop();


   
   // JumpingStop
   if(JumpingStop) JumpingStopLoss();

   //TrailingStop
   if(TrailingStop) TrailingStopLoss();

   

}//void TradeManagementModule()
//END TRADE MANAGEMENT MODULE
////////////////////////////////////////////////////////////////////////////////////////////////

bool SendSingleTrade(int type, string comment, double lotsize, double price, double stop, double take)
{
   //pah (Paul) contributed the code to get around the trade context busy error. Many thanks, Paul.
   
   int slippage = 10;
   if (Digits == 3 || Digits == 5) slippage = 100;
   
   //For CBI module. Set to true if the module detects a massive move
   if (TakingEmergencyAction) slippage = 1000;
   
   color col = Red;
   if (type == OP_BUY || type == OP_BUYSTOP) col = Green;
   
   int expiry = 0;
   //if (SendPendingTrades) expiry = TimeCurrent() + (PendingExpiryMinutes * 60);

   //RetryCount is declared as 10 in the Trading variables section at the top of this file
   for (int cc = 0; cc < RetryCount; cc++)
   {
      for (int d = 0; (d < RetryCount) && IsTradeContextBusy(); d++) Sleep(100);

      RefreshRates();
      if (type == OP_BUY) price = NormalizeDouble(Ask, Digits);
      if (type == OP_SELL) price = NormalizeDouble(Bid, Digits);
      
      if (!CriminalIsECN) int ticket = OrderSend(Symbol(),type, lotsize, price, slippage, stop, take, comment, MagicNumber, expiry, col);
   
   
      //Is a 2 stage criminal
      if (CriminalIsECN)
      {
         ticket = OrderSend(Symbol(),type, lotsize, price, slippage, 0, 0, comment, MagicNumber, expiry, col);
         if (ticket > -1)
         {
	           ModifyOrder(ticket, stop, take);
         }//if (ticket > 0)}
      }//if (CriminalIsECN)
      
      if (ticket > -1) break;//Exit the trade send loop
      if (cc == RetryCount - 1) return(false);
   
      //Error trapping for both
      if (ticket < 0)
      {
         string stype;
         if (type == OP_BUY) stype = "OP_BUY";
         if (type == OP_SELL) stype = "OP_SELL";
         if (type == OP_BUYLIMIT) stype = "OP_BUYLIMIT";
         if (type == OP_SELLLIMIT) stype = "OP_SELLLIMIT";
         if (type == OP_BUYSTOP) stype = "OP_BUYSTOP";
         if (type == OP_SELLSTOP) stype = "OP_SELLSTOP";
         int err=GetLastError();
         Alert(Symbol(), " ", WindowExpertName(), " ", stype," order send failed with error(",err,"): ",ErrorDescription(err));
         Print(Symbol(), " ", WindowExpertName(), " ", stype," order send failed with error(",err,"): ",ErrorDescription(err));
         return(false);
      }//if (ticket < 0)  
   }//for (int cc = 0; cc < RetryCount; cc++);
   
   
   TicketNo = ticket;
   //Make sure the trade has appeared in the platform's history to avoid duplicate trades.
   //My mod of Matt's code attempts to overcome the bastard crim's attempts to overcome Matt's code.
   bool TradeReturnedFromCriminal = false;
   while (!TradeReturnedFromCriminal)
   {
      TradeReturnedFromCriminal = O_R_CheckForHistory(ticket);
      if (!TradeReturnedFromCriminal)
      {
         Alert(Symbol(), " sent trade not in your trade history yet. Turn of this ea NOW.");
      }//if (!TradeReturnedFromCriminal)
   }//while (!TradeReturnedFromCriminal)
   
   //Got this far, so trade send succeeded
   return(true);
   
}//End bool SendSingleTrade(int type, string comment, double lotsize, double price, double stop, double take)

void ModifyOrder(int ticket, double stop, double take)
{
   //Modifies an order already sent if the crim is ECN.

   if (stop == 0 && take == 0) return; //nothing to do

   if (!OrderSelect(ticket, SELECT_BY_TICKET) ) return;//Trade does not exist, so no mod needed
   
   //RetryCount is declared as 10 in the Trading variables section at the top of this file   
   for (int cc = 0; cc < RetryCount; cc++)
   {
      for (int d = 0; (d < RetryCount) && IsTradeContextBusy(); d++) Sleep(100);
        if (take > 0 && stop > 0)
        {
           while(IsTradeContextBusy()) Sleep(100);
           if (OrderModify(ticket, OrderOpenPrice(), stop, take, OrderExpiration(), CLR_NONE)) return;           
        }//if (take > 0 && stop > 0)
   
        if (take != 0 && stop == 0)
        {
           while(IsTradeContextBusy()) Sleep(100);
           if (OrderModify(ticket, OrderOpenPrice(), OrderStopLoss(), take, OrderExpiration(), CLR_NONE)) return;
        }//if (take == 0 && stop != 0)

        if (take == 0 && stop != 0)
        {
           while(IsTradeContextBusy()) Sleep(100);
           if (OrderModify(ticket, OrderOpenPrice(), stop, OrderTakeProfit(), OrderExpiration(), CLR_NONE)) return;
        }//if (take == 0 && stop != 0)
   }//for (int cc = 0; cc < RetryCount; cc++)
   
   //Got this far, so the order modify failed
   int err=GetLastError();
   Print(Symbol(), " SL/TP  order modify failed with error(",err,"): ",ErrorDescription(err));               
   Alert(Symbol(), " SL/TP  order modify failed with error(",err,"): ",ErrorDescription(err));               

}//void ModifyOrder(int ticket, double tp, double sl)



bool IsTradingAllowed()
{
   //Returns false if any of the filters should cancel trading, else returns true to allow trading
   
      
   //Maximum spread
   if (MarketInfo(Symbol(), MODE_SPREAD) > MaxSpread) return(false);
 
 
   //Swap filter
   if (OpenTrades == 0) TradeDirectionBySwap();

   //An individual currency can only be traded twice, so check for this
   CanTradeThisPair = true;
   if (OnlyTradeCurrencyTwice && OpenTrades == 0)
   {
      IsThisPairTradable();      
   }//if (OnlyTradeCurrencyTwice)
   if (!CanTradeThisPair) return(false);
   
   
   
   
   return(true);


}//End bool IsTradingAllowed()

double CalculateLotSize(double price1, double price2)
{
   //Calculate the lot size by risk. Code kindly supplied by jmw1970. Nice one jmw.
   
   if (price1 == 0 || price2 == 0) return(Lot);//Just in case
   
   double FreeMargin = AccountFreeMargin();
   double TickValue = MarketInfo(Symbol(),MODE_TICKVALUE) ;
   double LotStep = MarketInfo(Symbol(),MODE_LOTSTEP);


   double SLPts = MathAbs(price1 - price2);
   SLPts/= Point;
   
   double Exposure = SLPts * TickValue; // Exposure based on 1 full lot

   double AllowedExposure = (FreeMargin * RiskPercent) / 100;
   
   int TotalSteps = ((AllowedExposure / Exposure) / LotStep);
   double LotSize = TotalSteps * LotStep;

   double MinLots = MarketInfo(Symbol(), MODE_MINLOT);
   double MaxLots = MarketInfo(Symbol(), MODE_MAXLOT);
   
   if (LotSize < MinLots) LotSize = MinLots;
   if (LotSize > MaxLots) LotSize = MaxLots;
   return(LotSize);

}//double CalculateLotSize(double price1, double price1)

void LookForTradingOpportunities()
{

   double target;
   if (ObjectFind(pendingpriceline) > -1) target = ObjectGet(pendingpriceline, OBJPROP_PRICE1);//In case the line needs moving
   color col = ObjectGet(pendingpriceline, OBJPROP_COLOR);
   
   RefreshRates();
   //Check filters
   if (!IsTradingAllowed() ) return;
   
   //Long 
   if (OverallTrend == up)
   {
      if (!TradeLong) return;
      
      //Big number filter
      if (RoundNumberHigh == BigNumberHigh && !TradeBigNumbers) return;
   
      ////////////////////////////////////////////////////////////////////////////////////////////
      //Add the filters required to allow the trade. Use by removing the comment symbols      
      if (UseRsiTrendDetection && (RsiTrend != up || TrendRsiVal < 55 + RsiBuffer)) return;
      if (UseSlowkey && SlowkeyTrend != up) return;
      if (UseAA && AaTrend != up) return;
      if (UseNanningBobForTrend && NbTrend != up) return;

      //Hanover RS
      if (UseHanover && !HanoverFilter(OP_BUY) ) return(false);
   
      
      //Balanced pair trade filter. Only apply to pre-recovery trades.
      //Will remove the comments when I add Recovery
      //if (OpenTrades + 1 < Start_Recovery_at_trades || !UseRecovery)
      //{
         if (UseZeljko && !BalancedPair(OP_BUY) ) return;
      //}//if (OpenTrades + 1 < Start_Recovery_at_trades)
      ////////////////////////////////////////////////////////////////////////////////////////////
      
      //Got this far, so there is going to be a trade send of some sort. Setting up price here makes
      //this code most easily adaptable to easy alteration
      if (ObjectFind(pendingpriceline) == -1 || ((target - Ask > (MaxPendingPipsFromMarket * Point)) && target > 0) || col == Red)
      {
         ObjectDelete(pendingpriceline);
         ObjectCreate(pendingpriceline, OBJ_HLINE, 0, TimeCurrent(), RoundNumberHigh);
         ObjectSet(pendingpriceline, OBJPROP_COLOR, BuyLineColour);
         ObjectSet(pendingpriceline, OBJPROP_STYLE, STYLE_DASH);
      }//if (ObjectFind(pendingpriceline) == -1 || (Ask - RoundNumberLow > (MaxPendingPipsFromMarket * Point)) )
      
      
   }//if (OverallTrend == up)
   
   
   //Short
   if (OverallTrend == down)
   {
      if (!TradeShort) return;

      //Big number filter
      if (RoundNumberHigh == BigNumberHigh && !TradeBigNumbers) return;

      ////////////////////////////////////////////////////////////////////////////////////////////
      //Add the filters required to allow the trade. Use by removing the comment symbols      
      if (UseRsiTrendDetection && (RsiTrend != down || TrendRsiVal > 45 - RsiBuffer)) return;
      if (UseSlowkey && SlowkeyTrend != down) return;
      if (UseAA && AaTrend != down) return;
      if (UseNanningBobForTrend && NbTrend != down) return;
      
      //Hanover RS
      if (UseHanover && !HanoverFilter(OP_SELL) ) return(false);

      //Balanced pair trade filter. Only apply to pre-recovery trades
      //Will remove the comments when I add Recovery
      //if (OpenTrades + 1 < Start_Recovery_at_trades || !UseRecovery)
      //{
         if (UseZeljko && !BalancedPair(OP_SELL) ) return;
      //}//if (OpenTrades + 1 < Start_Recovery_at_trades)
      ////////////////////////////////////////////////////////////////////////////////////////////
      
      //Got this far, so there is going to be a trade send of some sort. Setting up price here makes
      //this code most easily adaptable to easy alteration
      if (ObjectFind(pendingpriceline) == -1 || ((Bid - target > (MaxPendingPipsFromMarket * Point)) && target > 0) || col == Green)
      {
         ObjectDelete(pendingpriceline);
         ObjectCreate(pendingpriceline, OBJ_HLINE, 0, TimeCurrent(), RoundNumberLow);
         ObjectSet(pendingpriceline, OBJPROP_COLOR, SellLineColour);
         ObjectSet(pendingpriceline, OBJPROP_STYLE, STYLE_DASH);
      }//if (ObjectFind(pendingpriceline) == -1 || (Ask - RoundNumberLow > (MaxPendingPipsFromMarket * Point)) )

   }//if (Ask < 0)
   

   
   

}//void LookForTradingOpportunities()

void HasBuyFilled()
{
   //This function examines the Ask to see if a pending Buy price has been reached, and sends the trade if so.
   //Uses the Bid for buys also, as this is the price we see on the chart and the hi-lo is the Bid hi-lo.

   double take, stop, price;
   int type;
   double SendLot = Lot;
   bool CancelTrade = false;

   //Check filters
   if (!IsTradingAllowed() ) CancelTrade = true;
   if (UseZeljko && !BalancedPair(OP_BUY) ) CancelTrade = true;

   if (CancelTrade)
   {
      ObjectDelete(pendingpriceline);
      return;
   }//if (CancelTrade)
   
   
   //Set pending price 
   if (ObjectFind(pendingpriceline) > -1) double PendingPrice = ObjectGet(pendingpriceline, OBJPROP_PRICE1);
   
   RefreshRates();
   if (Ask > PendingPrice && PendingPrice > 0)
   {
      price = Ask;
      type = OP_BUY;
    
      //We need o ensure we are not repeatedly opening trades by bouncing around the round number.
      //CountOpenTrades always holds the TicketNumber of the most recent trade
      if (OpenTrades > 0)
      {
         OrderSelect(TicketNo, SELECT_BY_TICKET);
         if (OrderOpenPrice() > Ask || Ask - OrderOpenPrice() < (MinPipsBetweenTrades * Point) )
         {
            ObjectDelete(pendingpriceline);
            return;
         }//if (OrderOpenPrice() > Ask || Ask - OrderOpenPrice() < (MinPipsBetweenTrades * Point) )
      }//if (OpenTrades > 0)
      
      

      //Stop loss calculations
      //if (StopLoss > 0) stop = NormalizeDouble(price - (StopLoss * Point), Digits);
      
      
      //Take profit calculations
      if (TakeProfit > 0) take = NormalizeDouble(price + (TakeProfit * Point), Digits);
      
      //Risk based lot calculator
      if (RiskPercent > 0) SendLot = CalculateLotSize(price, stop);
      
      bool result = SendSingleTrade(type, TradeComment, SendLot, price, stop, take);
      if (result)
      {
         ObjectDelete(pendingpriceline);
      }//if (result)
      
      
      
   }//if (Ask >= PendingPrice)
   

}//End void HasBuyFilled()

void HasSellFilled()
{
   //This function examines the Bid to see if a pending Buy price has been reached, and sends the trade if so

   double take, stop, price;
   int type;
   double SendLot = Lot;
   bool CancelTrade = false;
   
   //Check filters
   if (!IsTradingAllowed() ) CancelTrade = true;
   if (UseZeljko && !BalancedPair(OP_SELL) ) CancelTrade = true;

   if (CancelTrade)
   {
      ObjectDelete(pendingpriceline);
      return;
   }//if (CancelTrade)


   //Set pending price 
   if (ObjectFind(pendingpriceline) > -1) double PendingPrice = ObjectGet(pendingpriceline, OBJPROP_PRICE1);
   
   RefreshRates();
   if (Bid <= PendingPrice && PendingPrice > 0)
   {
      price = Bid;
      type = OP_SELL;
      
      //We need o ensure we are not repeatedly opening trades by bouncing around the round number.
      //CountOpenTrades always holds the TicketNumber of the most recent trade
      if (OpenTrades > 0)
      {
         OrderSelect(TicketNo, SELECT_BY_TICKET);
         if (Bid > OrderOpenPrice() || OrderOpenPrice() - Bid < (MinPipsBetweenTrades * Point) )
         {
            ObjectDelete(pendingpriceline);
            return;
         }//if (OrderOpenPrice() > Ask || Ask - OrderOpenPrice() < (MinPipsBetweenTrades * Point) )
      }//if (OpenTrades > 0)

      //Stop loss calculator
      //if (StopLoss > 0) stop = NormalizeDouble(price + (StopLoss * Point), Digits);
      
      
      //Take profit calculations
      if (TakeProfit > 0) take = NormalizeDouble(price - (TakeProfit * Point), Digits);
      
      //Risk based lot calculator
      if (RiskPercent > 0) SendLot = CalculateLotSize(stop, price);

      bool result = SendSingleTrade(type, TradeComment, SendLot, price, stop, take);
      if (result)
      {
         ObjectDelete(pendingpriceline);
      }//if (result)
            
   }//if (Bid <= PendingPrice)
   

}//End void HasSellFilled()


bool CloseTrade(int ticket)
{   
   while(IsTradeContextBusy()) Sleep(100);
   bool result = OrderClose(ticket, OrderLots(), OrderClosePrice(), 1000, CLR_NONE);

   //Actions when trade send succeeds
   if (result)
   {
      return(true);
   }//if (result)
   
   //Actions when trade send fails
   if (!result)
   {
      return(false);
   }//if (!result)
   

}//End bool CloseTrade(ticket)

////////////////////////////////////////////////////////////////////////////////////////////////
//Indicator module

/*
void GetBB(int shift)
{
   //Reads BB figures into BbUpper, BbMiddle, BbLower
   
   
   BbUpper = iBands(NULL, 0, BbPeriod, BbDeviation, 0, PRICE_OPEN, MODE_UPPER, shift);
   BbLower = iBands(NULL, 0, BbPeriod, BbDeviation, 0, PRICE_OPEN, MODE_LOWER, shift);
   BbMiddle = iBands(NULL, 0, BbPeriod, BbDeviation, 0, PRICE_OPEN, MODE_MAIN, shift);
   
   BbExtent = BbUpper - BbLower;
   
}//void GetBb(int shift)
*/


double GetRsi(int tf, int period, int ap, int shift)
{
   return(iRSI(NULL, tf, period, ap, shift) );
}//End double GetRsi(int tf, int period, int ap, int shift)



double GetMa(int tf, int period, int mashift, int method, int ap, int shift)
{
   return(iMA(NULL, tf, period, mashift, method, ap, shift) );
}//End double GetMa(int tf, int period, int mashift, int method, int ap, int shift)

/*
double CalculateVolatility(int period, int LookBack)
{
   //Calculates the volatility of a pair based on an average of their movement over LookBack periods
   
   double pips;
   for (int cc = 1; cc < LookBack; cc++)
   {
      pips+= iHigh(NULL, period, cc) - iLow(NULL, period, cc);      
   }//for (int cc = 1; cc < LookBack; cc++)
   
   pips/= LookBack;//Average pips movement per day
   //Alert(pips);

   //Convert to pips
   int multiplier;
   if (Digits == 2) multiplier = 10;
   if (Digits == 3) multiplier = 100;
   if (Digits == 4) multiplier = 1000;
   if (Digits == 5) multiplier = 10000;
   
   pips*= multiplier;
   int rpips = pips;//Convert to a simple integer - all we need
   
   return(rpips);
   
}//End double CalculateVolatility(int period, int LookBack)
*/

double GetAa(int tf, int price, int period, int mashift, int method, int buffer, int shift)
{

   return(iCustom(NULL, 0, "AllAverages_v2.1 cc", tf, price, period, mashift, method, buffer, shift));

}//End double GetAa(int tf, int price, int period, int mashift, int method, int buffer, int shift)

void CalculateDailyResult()
{
   //Calculate the no of winners and losers from today's trading. These are held in the history tab.

   LossTrades = 0;
   WinTrades = 0;
   OverallProfit = 0;
   
   
   for (int cc = 0; cc <= OrdersHistoryTotal(); cc++)
   {
      if (!OrderSelect(cc, SELECT_BY_POS, MODE_HISTORY) ) continue;
      if (OrderSymbol() != Symbol() ) continue;
      if (OrderMagicNumber() != MagicNumber) continue;
      
      OverallProfit+= (OrderProfit() + OrderSwap() + OrderCommission() );
      if (OrderProfit() > 0) WinTrades++;
      if (OrderProfit() < 0) LossTrades++;
   }//for (int cc = 0; cc <= tot -1; cc++)
   
   

}//End void CalculateDailyResult()


void ReadIndicatorValues()
{

   //GetBB(0);
   //RsiVal = GetRsi(RsiTf, RsiPeriod, RsiAppliedPrice, 0);
   //MaVal = GetMa(MaTF, MaPeriod, MaShift, MaMethod, MaAppliedPrice, 0);
   //Volatility = CalculateVolatility(PERIOD_D1, LookBackDays);
   
}//void ReadIndicatorValues()

//End Indicator module
////////////////////////////////////////////////////////////////////////////////////////////////

bool LookForTradeClosure(int ticket)
{
   //Close the trade if the close conditions are met.
   //Called from within CountOpenTrades(). Returns true if a close is needed and succeeds, so that COT can increment cc,
   //else returns false
   
   if (!OrderSelect(ticket, SELECT_BY_TICKET) ) return(true);
   if (OrderSelect(ticket, SELECT_BY_TICKET) && OrderCloseTime() > 0) return(true);
   
   bool CloseThisTrade, HalfCloseThisTrade;
   
   string LineName = TpPrefix + DoubleToStr(ticket, 0);
   //Work with the lines on the chart that represent the hidden tp/sl
   double take = ObjectGetValueByShift(LineName, 0);
   LineName = SlPrefix + DoubleToStr(ticket, 0);
   double stop = ObjectGetValueByShift(LineName, 0);
   
   //Sometimes the sl line is not straight. This appears to happen when the trade is half-closed and the stop moved
   //to breakeven. I cannot work out why, so this next code block forces G to replace the line at the next tick
   double pp1 = ObjectGet(LineName, OBJPROP_PRICE1);
   double pp2 = ObjectGet(LineName, OBJPROP_PRICE2);

   if (pp1 != pp2)
   {
      ObjectDelete(LineName);
      return;
   }//if (pp1 != pp2)
   
   
   if (OrderType() == OP_BUY)
   {
      //TP
      if (Bid >= take && take > 0 && OrderLots() == Lot) HalfCloseThisTrade = true;
      //SL
      if (Bid <= stop && stop > 0) CloseThisTrade = true;
      
      //Trend change
      if (CloseTradesOnTrendChange && OverallTrend != up) CloseThisTrade = true;

   }//if (OrderType() == OP_BUY)
   
   
   if (OrderType() == OP_SELL)
   {
      //TP
      if (Bid <= take && take > 0 && OrderLots() == Lot) HalfCloseThisTrade = true;
      //SL
      if (Bid >= stop && stop > 0) CloseThisTrade = true;

      //Trend change
      if (CloseTradesOnTrendChange && OverallTrend != down) CloseThisTrade = true;

   }//if (OrderType() == OP_SELL)
   
   if (CloseThisTrade)
   {
      bool result = CloseTrade(TicketNo);
      //Actions when trade close succeeds
      if (result)
      {
         DeletePendingPriceLines();
         TicketNo = -1;//TicketNo is the most recently trade opened, so this might need editing in a multi-trade EA
         OpenTrades--;//Rather than OpenTrades = 0 to cater for multi-trade EA's
         return(true);//Makes CountOpenTrades increment cc to avoid missing out ccounting a trade
      }//if (result)
   
      //Actions when trade close fails
      if (!result)
      {
         return(false);//Do not increment cc
      }//if (!result)
   }//if (CloseThisTrade)
   
   
   if (HalfCloseThisTrade)
   {
      result = OrderClose(OrderTicket(), OrderLots() / 2, OrderClosePrice(), 5000, Blue);
      //Actions when trade close succeeds
      if (result)
      {
         //Delete the old stealth lines
         ObjectDelete(LineName);
         LineName = TpPrefix + DoubleToStr(ticket, 0);
         //Need to reselect the trade as it will have a new ticket
         for (int cc = OrdersTotal() - 1; cc >= 0; cc--)
         {
            //Ensure the trade is still open
            if (!OrderSelect(cc, SELECT_BY_POS) ) continue;
            //Ensure the EA 'owns' this trade
            if (OrderSymbol() != Symbol() ) continue;
            if (OrderMagicNumber() != MagicNumber) continue;
            TicketNo = OrderTicket();
            BreakEvenStopLoss();//Moves stop to BE
            return(false);//Do not increment cc
         }//for (int cc = OrdersTotal() - 1; cc >= 0; cc--)
         
      }//if (result)
   
      //Actions when trade close succeeds
      if (!result)
      {
         Alert(Symbol(), " half-close");
      }//if (!result)
   
      //Actions when trade close fails
      if (!result)
      {
         return(false);//Do not increment cc
      }//if (!result)
   
   }//if (HalfCloseThisTrade)
   
   
   
   //Got this far, so no trade closure
   return(false);//Do not increment cc
   
}//End bool LookForTradeClosure()

void CloseAllTrades()
{
   ForceTradeClosure= false;
   
   if (OrdersTotal() == 0) return;
   
   for (int cc = OrdersTotal() - 1; cc >= 0; cc--)
   {
      if (!OrderSelect(cc, SELECT_BY_POS) ) continue;
      if (OrderMagicNumber() != MagicNumber) continue;
      if (OrderSymbol() != Symbol() ) continue;
      while(IsTradeContextBusy()) Sleep(100);
      if (OrderType() == OP_BUY || OrderType() == OP_SELL) bool result = OrderClose(OrderTicket(), OrderLots(), OrderClosePrice(), 1000, CLR_NONE);
      if (result) cc++;
      if (!result) ForceTradeClosure= true;
      
   }//for (int cc = OrdersTotal() - 1; cc >= 0; cc--)

   //If full closure succeeded, then allow new trading
   if (!ForceTradeClosure) 
   {
      OpenTrades = 0;
      BuyOpen = false;
      SellOpen = false;
   }//if (!ForceTradeClosure) 

}//End void CloseAllTrades()


bool CheckTradingTimes()
{
   int hour = TimeHour(TimeLocal() );
   
   if (end_hourm < start_hourm)
	{
		end_hourm += 24;
	}
	

	if (end_houre < start_houre)
	{
		end_houre += 24;
	}
	
	bool ok2Trade = true;
	
	ok2Trade = (hour >= start_hourm && hour <= end_hourm) || (hour >= start_houre && hour <= end_houre);

	// adjust for past-end-of-day cases
	// eg in AUS, USDJPY trades 09-17 and 22-06
	// so, the above check failed, check if it is because of this condition
	if (!ok2Trade && hour < 12)
	{
 		hour += 24;
		ok2Trade = (hour >= start_hourm && hour <= end_hourm) || (hour >= start_houre && hour <= end_houre);		
		// so, if the trading hours are 11pm - 6am and the time is between  midnight to 11am, (say, 5am)
		// the above code will result in comparing 5+24 to see if it is between 23 (11pm) and 30(6+24), which it is...
	}


   // check for end of day by looking at *both* end-hours

   if (hour >= MathMax(end_hourm, end_houre))
   {      
      ok2Trade = false;
   }//if (hour >= MathMax(end_hourm, end_houre))

   return(ok2Trade);

}//bool CheckTradingTimes()

void CountOpenTrades()
{
   //Not all these will be needed. Which ones are depends on the individual EA.
   OpenTrades = 0;
   TicketNo = -1;
   BuyOpen = false;
   SellOpen = false;
   PendingBuyOpen = false;
   PendingSellOpen = false;
   int type;//Saves the OrderType() for consulatation later in the function
   TradeOpenInThisBand=false;
   
   upl = 0;//Unrealised profit and loss for hedging/recovery basket closure decisions

   if (OrdersTotal() == 0) return;
   
   //Iterating backwards through the orders list caters more easily for closed trades than iterating forwards
   for (int cc = OrdersTotal() - 1; cc >= 0; cc--)
   {
      bool TradeWasClosed = false;//See 'check for possible trade closure'

      //Ensure the trade is still open
      if (!OrderSelect(cc, SELECT_BY_POS) ) continue;
      //Ensure the EA 'owns' this trade
      if (OrderSymbol() != Symbol() ) continue;
      if (OrderMagicNumber() != MagicNumber) continue;
      
      //Band already traded check
      if (OpenTrades == 0)
      {
         if (OrderType() == OP_BUY)
         {
            if (RoundNumberHigh - OrderOpenPrice() < (MinPipsBetweenTrades * Point) )
            {
               TradeOpenInThisBand = true;
               ObjectDelete(pendingpriceline);
            }//if (RoundNumberHigh - OrderOpenPrice() < (MinPipsBetweenTrades * Point) )
         }//if (OrderType == OP_BUY)         

         if (OrderType() == OP_SELL)
         {
            if (OrderOpenPrice() - RoundNumberLow < (MinPipsBetweenTrades * Point) )
            {
               TradeOpenInThisBand = true;
               ObjectDelete(pendingpriceline);
            }//if (OrderOpenPrice() - RoundNumberLow < (MinPipsBetweenTrades * Point) )
         }//if (OrderType == OP_SELL)         
      }//if (OpenTrades == 0)
      
      
      //All conditions passed, so carry on
      type = OrderType();//Store the order type
      
      OpenTrades++;
      //Store the latest trade sent. Most of my EA's only need this final ticket number as either they are single trade
      //bots or the last trade in the sequence is the important one. Adapt this code for your own use.
      if (TicketNo  == -1) TicketNo = OrderTicket();
      
      //upl might not be needed. Depends on the individual EA
      upl+= (OrderProfit() + OrderSwap() + OrderCommission()); 
      //The next line of code calculates the pips upl of an open trade. As yet, I have done nothing with it.
      //something = CalculateTradeProfitInPips()
      
      //Trade types
      if (OrderType() == OP_BUY) BuyOpen = true;
      if (OrderType() == OP_SELL) SellOpen = true;
      //These might need extra coding if both stop and limit orders are used
      if (OrderType() == OP_BUYSTOP || OrderType() == OP_BUYLIMIT) PendingBuyOpen = true;
      if (OrderType() == OP_SELLSTOP || OrderType() == OP_SELLLIMIT) PendingSellOpen = true;
      //Add missing tp/sl in case rapidly moving markets prevent their addition - ECN
      //if (OrderStopLoss() == 0 && StopLoss > 0) InsertStopLoss(TicketNo);
      //if (OrderTakeProfit() == 0 && TakeProfit > 0) InsertTakeProfit(TicketNo);

      //Replace missing tp and sl lines
      ReplaceMissingSlTpLines();
      
      //Check for possible trade closure and order management. Only if hedging and Recovery are not in progress.
      //Extra code will be needed if Caterpillar is being used. As coded, Cat and Recovery are not compatible - it must
      //be one or the other
      if (!HedgingInProgress && (type == OP_BUY || type == OP_SELL) )
      {
         if (HiddenPips > 0) 
         {
            TradeWasClosed = LookForTradeClosure(OrderTicket() );
            if (TradeWasClosed) 
            {
               if (type == OP_BUY) BuyOpen = false;//Will be reset if subsequent trades are buys that are not closed
               if (type == OP_SELL) SellOpen = false;//Will be reset if subsequent trades are sells that are not closed
               cc++;
            }//if (TradeWasClosed) 
            
         }//if (HiddenPips > 0) 
         
         if (OrderProfit() > 0 && !TradeWasClosed) TradeManagementModule();
      }//if (!HedgingInProgress && !RecoveryInProgress && (type == OP_BUY || type == OP_SELL) )
      
   }//for (int cc = OrdersTotal() - 1; cc <= 0; c`c--)
   
   //Detect Recovery and Hedging. Both HedgingInProgress and RecoveryInProgress are reset to false in start(),
   //if the call to this function results in OpenTrades == 0
   //Detect hedging
   if (BuyOpen && SellOpen) HedgingInProgress = true;
   
   
}//End void CountOpenTrades();

/*
void InsertStopLoss(int ticket)
{
   //Inserts a stop loss if the ECN crim managed to swindle the original trade out of the modification at trade send time
   //Called from CountOpenTrades() if StopLoss > 0 && OrderStopLoss() == 0.
   
   while(IsTradeContextBusy()) Sleep(100);
   if (!OrderSelect(ticket, SELECT_BY_TICKET) || OrderCloseTime() > 0) return;
   
   double stop;
   
   if (OrderType() == OP_BUY)
   {
      stop = NormalizeDouble(OrderOpenPrice() - (StopLoss * Point), Digits);
   }//if (OrderType() == OP_BUY)
   
   if (OrderType() == OP_SELL)
   {
      stop = NormalizeDouble(OrderOpenPrice() + (StopLoss * Point), Digits);
   }//if (OrderType() == OP_SELL)
   

   OrderModify(ticket, OrderOpenPrice(), stop, OrderTakeProfit(), OrderExpiration(), CLR_NONE);

}//End void InsertStopLoss(int ticket)

void InsertTakeProfit(int ticket)
{
   //Inserts a TP if the ECN crim managed to swindle the original trade out of the modification at trade send time
   //Called from CountOpenTrades() if TakeProfit > 0 && OrderTakeProfit() == 0.
   
   while(IsTradeContextBusy()) Sleep(100);
   if (!OrderSelect(ticket, SELECT_BY_TICKET) || OrderCloseTime() > 0) return;
   
   double take;
   
   if (OrderType() == OP_BUY)
   {
      take = NormalizeDouble(OrderOpenPrice() + (TakeProfit * Point), Digits);
   }//if (OrderType() == OP_BUY)
   
   if (OrderType() == OP_SELL)
   {
      take = NormalizeDouble(OrderOpenPrice() - (TakeProfit * Point), Digits);
   }//if (OrderType() == OP_SELL)
   

   OrderModify(ticket, OrderOpenPrice(), OrderStopLoss(), take, OrderExpiration(), CLR_NONE);

}//End void InsertStopLoss(int ticket)
*/

//=============================================================================
//                           O_R_CheckForHistory()
//
//  This function is to work around a very annoying and dangerous bug in MT4:
//      immediately after you send a trade, the trade may NOT show up in the
//      order history, even though it exists according to ticket number.
//      As a result, EA's which count history to check for trade entries
//      may give many multiple entries, possibly blowing your account!
//
//  This function will take a ticket number and loop until
//  it is seen in the history.
//
//  RETURN VALUE:
//     TRUE if successful, FALSE otherwise
//
//
//  FEATURES:
//     * Re-trying under some error conditions, sleeping a random
//       time defined by an exponential probability distribution.
//
//     * Displays various error messages on the log for debugging.
//
//  ORIGINAL AUTHOR AND DATE:
//     Matt Kennel, 2010
//
//=============================================================================
bool O_R_CheckForHistory(int ticket)
{
   //My thanks to Matt for this code. He also has the undying gratitude of all users of my trading robots
   
   int lastTicket = OrderTicket();

   int cnt = 0;
   int err = GetLastError(); // so we clear the global variable.
   err = 0;
   bool exit_loop = false;
   bool success=false;

   while (!exit_loop) {
      /* loop through open trades */
      int total=OrdersTotal();
      for(int c = 0; c < total; c++) {
         if(OrderSelect(c,SELECT_BY_POS,MODE_TRADES) == true) {
            if (OrderTicket() == ticket) {
               success = true;
               exit_loop = true;
            }
         }
      }
      if (cnt > 3) {
         /* look through history too, as order may have opened and closed immediately */
         total=OrdersHistoryTotal();
         for(c = 0; c < total; c++) {
            if(OrderSelect(c,SELECT_BY_POS,MODE_HISTORY) == true) {
               if (OrderTicket() == ticket) {
                  success = true;
                  exit_loop = true;
               }
            }
         }
      }

      cnt = cnt+1;
      if (cnt > O_R_Setting_max_retries) {
         exit_loop = true;
      }
      if (!(success || exit_loop)) {
         Print("Did not find #"+ticket+" in history, sleeping, then doing retry #"+cnt);
         O_R_Sleep(O_R_Setting_sleep_time, O_R_Setting_sleep_max);
      }
   }
   // Select back the prior ticket num in case caller was using it.
   if (lastTicket >= 0) {
      OrderSelect(lastTicket, SELECT_BY_TICKET, MODE_TRADES);
   }
   if (!success) {
      Print("Never found #"+ticket+" in history! crap!");
   }
   return(success);
}//End bool O_R_CheckForHistory(int ticket)

//=============================================================================
//                              O_R_Sleep()
//
//  This sleeps a random amount of time defined by an exponential
//  probability distribution. The mean time, in Seconds is given
//  in 'mean_time'.
//  This returns immediately if we are backtesting
//  and does not sleep.
//
//=============================================================================
void O_R_Sleep(double mean_time, double max_time)
{
   if (IsTesting()) {
      return;   // return immediately if backtesting.
   }

   double p = (MathRand()+1) / 32768.0;
   double t = -MathLog(p)*mean_time;
   t = MathMin(t,max_time);
   int ms = t*1000;
   if (ms < 10) {
      ms=10;
   }
   Sleep(ms);
}//End void O_R_Sleep(double mean_time, double max_time)


///////////////////////////////////////////////////////////////////////////////////////////////////////
//Balance/swap filters module
void TradeDirectionBySwap()
{

   //Sets TradeLong & TradeShort according to the positive/negative swap it attracts

   double LongSwap = MarketInfo(Symbol(), MODE_SWAPLONG);
   double ShortSwap = MarketInfo(Symbol(), MODE_SWAPSHORT);
   

   if (CadPairsPositiveOnly)
   {
      if (StringSubstr(Symbol(), 0, 3) == "CAD" || StringSubstr(Symbol(), 0, 3) == "cad" || StringSubstr(Symbol(), 3, 3) == "CAD" || StringSubstr(Symbol(), 3, 3) == "cad" )      
      {
         if (LongSwap > 0) TradeLong = true;
         else TradeLong = false;
         if (ShortSwap > 0) TradeShort = true;
         else TradeShort = false;         
      }//if (StringSubstr(Symbol(), 0, 3) == "CAD" || StringSubstr(Symbol(), 0, 3) == "cad" )      
   }//if (CadPairsPositiveOnly)
   
   if (AudPairsPositiveOnly)
   {
      if (StringSubstr(Symbol(), 0, 3) == "AUD" || StringSubstr(Symbol(), 0, 3) == "aud" || StringSubstr(Symbol(), 3, 3) == "AUD" || StringSubstr(Symbol(), 3, 3) == "aud" )      
      {
         if (LongSwap > 0) TradeLong = true;
         else TradeLong = false;
         if (ShortSwap > 0) TradeShort = true;
         else TradeShort = false;         
      }//if (StringSubstr(Symbol(), 0, 3) == "AUD" || StringSubstr(Symbol(), 0, 3) == "aud" || StringSubstr(Symbol(), 3, 3) == "AUD" || StringSubstr(Symbol(), 3, 3) == "aud" )      
   }//if (AudPairsPositiveOnly)
   
   
   if (NzdPairsPositiveOnly)
   {
      if (StringSubstr(Symbol(), 0, 3) == "NZD" || StringSubstr(Symbol(), 0, 3) == "nzd" || StringSubstr(Symbol(), 3, 3) == "NZD" || StringSubstr(Symbol(), 3, 3) == "nzd" )      
      {
         if (LongSwap > 0) TradeLong = true;
         else TradeLong = false;
         if (ShortSwap > 0) TradeShort = true;
         else TradeShort = false;         
      }//if (StringSubstr(Symbol(), 0, 3) == "AUD" || StringSubstr(Symbol(), 0, 3) == "aud" || StringSubstr(Symbol(), 3, 3) == "AUD" || StringSubstr(Symbol(), 3, 3) == "aud" )      
   }//if (AudPairsPositiveOnly)
   
   

}//void TradeDirectionBySwap()

bool IsThisPairTradable()
{
   //Checks to see if either of the currencies in the pair is already being traded twice.
   //If not, then return true to show that the pair can be traded, else return false
   
   string c1 = StringSubstr(Symbol(), 0, 3);//First currency in the pair
   string c2 = StringSubstr(Symbol(), 3, 3);//Second currency in the pair
   int c1open = 0, c2open = 0;
   CanTradeThisPair = true;
   for (int cc = OrdersTotal() - 1; cc >= 0; cc--)
   {
      if (!OrderSelect(cc, SELECT_BY_POS) ) continue;
      if (OrderSymbol() != Symbol() ) continue;
      if (OrderMagicNumber() != MagicNumber) continue;
      int index = StringFind(OrderSymbol(), c1);
      if (index > -1)
      {
         c1open++;         
      }//if (index > -1)
   
      index = StringFind(OrderSymbol(), c2);
      if (index > -1)
      {
         c2open++;         
      }//if (index > -1)
   
      if (c1open == 1 && c2open == 1) 
      {
         CanTradeThisPair = false;
         return(false);   
      }//if (c1open == 1 && c2open == 1) 
   }//for (int cc = OrdersTotal() - 1; cc >= 0; cc--)

   //Got this far, so ok to trade
   return(true);
   
}//End bool IsThisPairTradable()

bool BalancedPair(int type)
{

   //Only allow an individual currency to trade if it is a balanced trade
   //e.g. UJ Buy open, so only allow Sell xxxJPY.
   //The passed parameter is the proposed trade, so an existing one must balance that

   //This code courtesy of Zeljko (zkucera) who has my grateful appreciation.
   
   string BuyCcy1, SellCcy1, BuyCcy2, SellCcy2;

   if (type == OP_BUY || type == OP_BUYSTOP)
   {
      BuyCcy1 = StringSubstr(Symbol(), 0, 3);
      SellCcy1 = StringSubstr(Symbol(), 3, 3);
   }//if (type == OP_BUY || type == OP_BUYSTOP)
   else
   {
      BuyCcy1 = StringSubstr(Symbol(), 3, 3);
      SellCcy1 = StringSubstr(Symbol(), 0, 3);
   }//else

   for (int cc = OrdersTotal() - 1; cc >= 0; cc--)
   {
      if (!OrderSelect(cc, SELECT_BY_POS)) continue;
      if (OrderSymbol() == Symbol()) continue;
      if (OrderMagicNumber() != MagicNumber) continue;      
      if (OrderType() == OP_BUY || OrderType() == OP_BUYSTOP)
      {
         BuyCcy2 = StringSubstr(OrderSymbol(), 0, 3);
         SellCcy2 = StringSubstr(OrderSymbol(), 3, 3);
      }//if (OrderType() == OP_BUY || OrderType() == OP_BUYSTOP)
      else
      {
         BuyCcy2 = StringSubstr(OrderSymbol(), 3, 3);
         SellCcy2 = StringSubstr(OrderSymbol(), 0, 3);
      }//else
      if (BuyCcy1 == BuyCcy2 || SellCcy1 == SellCcy2) return(false);
   }//for (int cc = OrdersTotal() - 1; cc >= 0; cc--)

   //Got this far, so it is ok to send the trade
   return(true);

}//End bool BalancedPair(int type)



//End Balance/swap filters module
///////////////////////////////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////////////////////////////////
//Trend detection module

void TrendDetectionModule()
{

   static int OldNbBars;

   //Define the trend according to the user's choices.
   //Only called if UseTrendDetection is set to true
   OverallTrend = nomasterinuse;//Defaults to no master trend
   
   //Rsi. This one is scooby-doo's suggestion and is based on a 20 period D1 Rsi.
   if (UseRsiTrendDetection)
   {
      RsiTrend = ranging;
      TrendRsiVal = GetRsi(RsiTdTf, RsiTdPeriod, RsiTdAppliedPrice, 0);
      if (TrendRsiVal > 55) RsiTrend = up;
      if (TrendRsiVal < 45) RsiTrend = down;
      if (RsiIsMaster) OverallTrend = RsiTrend;
   }//if (UseRsiTrendDetection)

   //'slowkey' - double moving average.
   //Slow MA > Fast MA - trend is up and vice versa
   if (UseSlowkey)
   {
      SlowkeyTrend = none;
      FastTrendMaVal = GetMa(FastMaTdTF, FastMaTdPeriod, FastMaTdShift, FastMaTdMethod, FastMaTdAppliedPrice, 0);   
      SlowTrendMaVal = GetMa(SlowMaTdTF, SlowMaTdPeriod, SlowMaTdShift, SlowMaTdMethod, SlowMaTdAppliedPrice, 0); 
      if (FastTrendMaVal > SlowTrendMaVal) SlowkeyTrend = up;
      if (FastTrendMaVal < SlowTrendMaVal) SlowkeyTrend = down;
      if (SlowkeyIsMaster) OverallTrend = SlowkeyTrend;
   }//if (UseSlowkey)

   /*
   I picked this up from the book 'Trading Day by Day - Winning the Zero Sum Game' by FH Goslin.
   10 week MA is rising - trend is up.
   10 week MA is falling - trend is down.
   I use AllAverages for detecting this
   */
   if (UseAA)
   {
      AaVal = GetAa(TimeFrame, Price, MA_Period, MA_Shift, MA_Method, 0, CandleShift);
      AaUp = GetAa(TimeFrame, Price, MA_Period, MA_Shift, MA_Method, 1, CandleShift);//Up buffer
      AaDown = GetAa(TimeFrame, Price, MA_Period, MA_Shift, MA_Method, 3, CandleShift);//Down buffer
      
      if (AaUp != EMPTY_VALUE) AaTrend = up;
      if (AaDown != EMPTY_VALUE) AaTrend = down;
      if (AaUp != EMPTY_VALUE && AaDown != EMPTY_VALUE) AaTrend = ranging;//Happens at the turn

      if (AaIsMaster) OverallTrend = AaTrend;
   }//if (UseAA)
   
   //NB V10 2 moving averages.
   //D1 candle hi-lo above both ma's: trend is up. Below both: trend is down. In between: market is ranging.
   //Also makes an excellent trade trigger in a longer-term trend trading system.
   if (UseNanningBobForTrend)
   {
      NbTrend = ranging;
      
      if (OldNbBars != iBars(NULL, FastNbTdTF) )//Only need this call at the start of each candle
      {
         OldNbBars = iBars(NULL, FastNbTdTF);
         FastNbTrendMaVal = GetMa(FastNbTdTF, FastNbTdPeriod, FastNbTdShift, FastNbTdMethod, FastNbTdAppliedPrice, 0);   
         SlowNbTrendMaVal = GetMa(SlowNbTdTF, SlowNbTdPeriod, SlowNbTdShift, SlowNbTdMethod, SlowNbTdAppliedPrice, 0);          
      }//if (OldNbBars != iBars(NULL, FastNbTdTF) )
      
      //Detect uptrend
      if (iHigh(NULL, PERIOD_D1, 0) > FastNbTrendMaVal && iHigh(NULL, PERIOD_D1, 0) > SlowNbTrendMaVal 
         && iLow(NULL, PERIOD_D1, 0) > FastNbTrendMaVal && iLow(NULL, PERIOD_D1, 0) > SlowNbTrendMaVal) 
         {
            if (UseNanningBobForTrend) NbTrend = up;
         }//if (iHigh(NULL, PERIOD_D1, 0) > FastNbTrendMaVal && iHigh(NULL, PERIOD_D1, 0) > SlowNbTrendMaVal 
         
      //Detect downtrend
      if (iHigh(NULL, PERIOD_D1, 0) < FastNbTrendMaVal && iHigh(NULL, PERIOD_D1, 0) < SlowNbTrendMaVal 
         && iLow(NULL, PERIOD_D1, 0) < FastNbTrendMaVal && iLow(NULL, PERIOD_D1, 0) < SlowNbTrendMaVal) 
         {
            if (UseNanningBobForTrend) NbTrend = down;
         }//if (iHigh(NULL, PERIOD_D1, 0) < FastNbTrendMaVal && iHigh(NULL, PERIOD_D1, 0) < SlowNbTrendMaVal 
         
      if (NanningBobIsMaster) OverallTrend = NbTrend;
      
   }//if (UseNanningBobForTrend)
   
   //Delete the pending trade line if there is no trend
   if (OverallTrend != up && OverallTrend != down && ObjectFind(pendingpriceline) > -1)
   {
      ObjectDelete(pendingpriceline);
   }//if (OverallTrend != up && OverallTrend != down && ObjectFind(pendingpriceline) > -1)
   
   
}//void TrendDetectionModule()


//End Trend detection module
///////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////////
//Pending trade price lines module.
//Doubles up by providing missing lines for the stealth stuff
void DrawPendingPriceLines()
{
   //This function will work for a full pending-trade EA.
   //The pending tp/sl can be used for hiding the stops in a market-trading ea
   
   /*
   ObjectDelete(pendingpriceline);
   ObjectCreate(pendingpriceline, OBJ_HLINE, 0, TimeCurrent(), PendingPrice);
   if (PendingBuy) ObjectSet(pendingpriceline, OBJPROP_COLOR, Green);
   if (PendingSell) ObjectSet(pendingpriceline, OBJPROP_COLOR, Red);
   ObjectSet(pendingpriceline, OBJPROP_WIDTH, 1);
   ObjectSet(pendingpriceline, OBJPROP_STYLE, STYLE_DASH);
   */
   string LineName;
   
   double shift = iBarShift(NULL,Period(),OrderOpenTime(), false);
   
   LineName = TpPrefix + DoubleToStr(OrderTicket(), 0);
   HiddenTakeProfit = 0;
   if (ObjectFind(LineName) == -1)//Only need the tp for the first 100 pips
   {
      if (OrderType() == OP_BUY)
      {
         if (OrderTakeProfit() == 0) HiddenTakeProfit = NormalizeDouble(RoundNumberHigh, Digits); 
         if (HiddenTakeProfit - OrderOpenPrice() < (MinTp * Point) ) HiddenTakeProfit = NormalizeDouble(RoundNumberHigh + (TpAdjustment * Point), Digits);         
         if (OrderStopLoss() >= OrderOpenPrice() && OrderStopLoss() > 0) HiddenTakeProfit = 0;//Don't need a tp once BE is reached
      }//if (OrderType() == OP_BUY)
      
      if (OrderType() == OP_SELL)
      {
         if (OrderTakeProfit() == 0) HiddenTakeProfit = NormalizeDouble(RoundNumberLow, Digits);
         if (OrderOpenPrice() - HiddenTakeProfit < (MinTp * Point) ) HiddenTakeProfit = NormalizeDouble(RoundNumberLow - (TpAdjustment * Point), Digits);         
         if (OrderStopLoss() <= OrderOpenPrice()  && OrderStopLoss() > 0) HiddenTakeProfit = 0;//Don't need a tp once BE is reached
      }//if (OrderType() == OP_BUY)      
   }//if (ObjectFind(LineName) == -1)
   
   if (HiddenTakeProfit > 0 && ObjectFind(LineName) == -1)
   {
      ObjectDelete(LineName);
      ObjectCreate(LineName, OBJ_TREND, 0, iTime(NULL, Period(), shift), HiddenTakeProfit, iTime(NULL, Period(), shift) + (Period() * 60 * 3), HiddenTakeProfit);
      ObjectSet(LineName, OBJPROP_COLOR, Green);
      ObjectSet(LineName, OBJPROP_WIDTH, 1);
      ObjectSet(LineName, OBJPROP_STYLE, STYLE_DOT);
      ObjectSet(LineName, OBJPROP_RAY, true);
   }//if (HiddenTakeProfit > 0)
   
   
   LineName = SlPrefix + DoubleToStr(OrderTicket(), 0);//TicketNo is set by the calling function - either CountOpenTrades or DoesTradeExist
   HiddenStopLoss = 0;
   if (ObjectFind(LineName) == -1)
   {
      if (OrderType() == OP_BUY)
      {
         if (OrderStopLoss() == 0) HiddenStopLoss = NormalizeDouble(OrderOpenPrice() - (StopLoss * Point), Digits);
         else HiddenStopLoss = NormalizeDouble(OrderStopLoss() + (HiddenPips * Point), Digits);
      }//if (OrderType() == OP_BUY)
      
      if (OrderType() == OP_SELL)
      {
         if (OrderStopLoss() == 0) HiddenStopLoss = NormalizeDouble(OrderOpenPrice() + (StopLoss * Point), Digits);
         else HiddenStopLoss = NormalizeDouble(OrderStopLoss() - (HiddenPips * Point), Digits);
      }//if (OrderType() == OP_BUY)      
   }//if (ObjectFind(LineName) == -1)
   
   //if (HiddenStopLoss > 0 && (ObjectFind(LineName) == -1 || ) )
   if (HiddenStopLoss > 0)
   {
      ObjectDelete(LineName);
      ObjectCreate(LineName, OBJ_TREND, 0, iTime(NULL, Period(), shift), HiddenStopLoss, iTime(NULL, Period(), shift) + (Period() * 60 * 3), HiddenStopLoss);
      ObjectSet(LineName, OBJPROP_COLOR, Red);
      ObjectSet(LineName, OBJPROP_WIDTH, 1);
      ObjectSet(LineName, OBJPROP_STYLE, STYLE_DOT);
      ObjectSet(LineName, OBJPROP_RAY, true);
   }//if (HiddenStopLoss > 0)
   
   

}//End void DrawPendingPriceLines()


void DeletePendingPriceLines()
{

   
   //ObjectDelete(pendingpriceline);
   string LineName = TpPrefix + DoubleToStr(TicketNo, 0);
   ObjectDelete(LineName);
   LineName = SlPrefix + DoubleToStr(TicketNo, 0);
   ObjectDelete(LineName);
   
}//End void DeletePendingPriceLines()

void ReplaceMissingSlTpLines()
{

   DrawPendingPriceLines();

}//End void ReplaceMissingSlTpLines()

void DeleteOrphanTpSlLines()
{

   if (ObjectsTotal() == 0) return;
   
   for (int cc = ObjectsTotal() - 1; cc >= 0; cc--)
   {
      string name = ObjectName(cc);
      
      if ((StringSubstr(name, 0, 2) == TpPrefix || StringSubstr(name, 0, 2) == SlPrefix) 
           && (ObjectType(name) == OBJ_HLINE || ObjectType(name) == OBJ_TREND))
      {
         int tn = StrToDouble(StringSubstr(name, 2));
         if (tn > 0) 
         {
            if (!OrderSelect(tn, SELECT_BY_TICKET, MODE_TRADES) || OrderCloseTime() > 0)
            {
               ObjectDelete(name);
               cc++;
            }//if (!OrderSelect(tn, SELECT_BY_TICKET, MODE_TRADES) || OrderCloseTime() > 0)
            
         }//if (tn > 0) 
         
         
      }//if (StringSubstr(name, 0, 1) == TpPrefix)
      
   }//for (int cc = ObjectsTotal() - 1; cc >= 0; cc--)
   
   
}//End void DeleteOrphanTpSlLines()


//END Pending trade price lines module
///////////////////////////////////////////////////////////////////////////////////////////////////////



////////////////////////////////////////////////////////////////////////////////////////////////
//Hanover module
void SetUpArrays()
{
   //Sets up all the arrays required by this program

   int cc;
   int Index = 0;//For searching InputString
   int LastIndex = 0;//Points the the most recent Index
   

   //TimeFrames
   InputString = TimeFrames;
   CleanUpInputString();
   TimeFrames = InputString;
   NoOfTimeFrames = CalculateParamsPassed();
   string NewArray2 = ArrayResize(Tf, NoOfTimeFrames);
   
   Index = 0;//For searching InputString
   LastIndex = 0;//Points the the most recent Index
   for (cc = 0; cc < NoOfTimeFrames; cc ++)
   {
      Index = StringFind(InputString, ",",LastIndex);
      if (Index > -1)
      {
         Tf[cc] = StringSubstr(InputString, LastIndex,Index-LastIndex);
         Tf[cc] = StringTrimLeft(Tf[cc]);
         Tf[cc] = StringTrimRight(Tf[cc]);
         LastIndex = Index+1;
      }//if (Index > -1)      
   }//for (cc = 0; cc < NoOfTimeFrames; cc ++)

   //StrongWeak
   string NewArray3 = ArrayResize(StrongWeak, NoOfTimeFrames);
   string NewArray4 = ArrayResize(StrongestCcy, NoOfTimeFrames);
   string NewArray5 = ArrayResize(WeakestCcy, NoOfTimeFrames);
   double NewArray6 = ArrayResize(StrongVal, NoOfTimeFrames);
   double NewArray7 = ArrayResize(WeakVal, NoOfTimeFrames);
   double NewArray8 = ArrayResize(PrevStrongVal, NoOfTimeFrames);
   double NewArray9 = ArrayResize(PrevWeakVal, NoOfTimeFrames);
   double NewArray10 = ArrayResize(ConstructedPair, NoOfTimeFrames);

   //SlopeConfirmationCandles
   InputString = SlopeConfirmationCandles;
   CleanUpInputString();
   SlopeConfirmationCandles = InputString;
   string NewArray11 = ArrayResize(SlopeCandles, NoOfTimeFrames);

   Index = 0;//For searching InputString
   LastIndex = 0;//Points the the most recent Index
   for (cc = 0; cc < NoOfTimeFrames; cc ++)
   {
      Index = StringFind(InputString, ",", LastIndex);
      if (Index > -1)
      {
         SlopeCandles[cc] = StrToInteger(StringSubstr(InputString, LastIndex, Index-LastIndex));
         LastIndex = Index+1;
      }//if (Index > -1)
      else
      {
         SlopeCandles[cc] = 0;
      }
   }//for (cc = 0; cc < NoOfTimeFrames; cc ++)

}//End void SetUpArrays()

void CleanUpInputString()
{
   // Does any tidying up of the user inputs
   
   //Remove unwanted spaces
   InputString = StringTrimLeft(InputString);
   InputString = StringTrimRight(InputString);

   //Add final comma if ommitted by user
   if (StringSubstr(InputString, StringLen(InputString)-1) != ",") 
      InputString = StringConcatenate(InputString,",");
      
   
}//void CleanUpInputString

int CalculateParamsPassed()
{
   // Calculates the numbers of paramaters passed in LongMagicNumber and TradeComment.
   
   int Index = 0;//For searching NoTradePairs
   int LastIndex;//Points the the most recent Index
   int NoOfParams = 0;
   
   while(Index > -1)
   {
      Index = StringFind(InputString, ",",LastIndex);
      if (Index > -1)
      {
         NoOfParams++;
         LastIndex = Index+1;            
      }//if (Index > -1)
   }//while(int cc > -1)
      
  return(NoOfParams);
}//int CalculateParamsPassed()


//+------------------------------------------------------------------+
string StringRight(string str, int n=1)
//+------------------------------------------------------------------+
// Returns the rightmost N characters of STR, if N is positive
// Usage:    string x=StringRight("ABCDEFG",2)  returns x = "FG"
//
// Returns all but the leftmost N characters of STR, if N is negative
// Usage:    string x=StringRight("ABCDEFG",-2)  returns x = "CDEFG"
{
  if (n > 0)  return(StringSubstr(str,StringLen(str)-n,n));
  if (n < 0)  return(StringSubstr(str,-n,StringLen(str)-n));
  return("");
}


//+------------------------------------------------------------------+
int StringFindCount(string str, string str2)
//+------------------------------------------------------------------+
// Returns the number of occurrences of STR2 in STR
// Usage:   int x = StringFindCount("ABCDEFGHIJKABACABB","AB")   returns x = 3
{
  int c = 0;
  for (int i=0; i<StringLen(str); i++)
    if (StringSubstr(str,i,StringLen(str2)) == str2)  c++;
  return(c);
}


string StringUpper(string str)
//+------------------------------------------------------------------+
// Converts any lowercase characters in a string to uppercase
// Usage:    string x=StringUpper("The Quick Brown Fox")  returns x = "THE QUICK BROWN FOX"
{
  string outstr = "";
  string lower  = "abcdefghijklmnopqrstuvwxyz";
  string upper  = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
  for(int i=0; i<StringLen(str); i++)  {
    int t1 = StringFind(lower,StringSubstr(str,i,1),0);
    if (t1 >=0)  
      outstr = outstr + StringSubstr(upper,t1,1);
    else
      outstr = outstr + StringSubstr(str,i,1);
  }
  return(outstr);
}  

//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
string StringTrim(string str)
//+------------------------------------------------------------------+
// Removes all spaces (leading, traing embedded) from a string
// Usage:    string x=StringUpper("The Quick Brown Fox")  returns x = "TheQuickBrownFox"
{
  string outstr = "";
  for(int i=0; i<StringLen(str); i++)  {
    if (StringSubstr(str,i,1) != " ")
      outstr = outstr + StringSubstr(str,i,1);
  }
  return(outstr);
}

//+------------------------------------------------------------------+
int StrToStringArray(string str, string &a[], string delim=",", string init="")  {
//+------------------------------------------------------------------+
// Breaks down a single string into string array 'a' (elements delimited by 'delim')
  for (int i=0; i<ArraySize(a); i++)
    a[i] = init;
  int z1=-1, z2=0;
  if (StringRight(str,1) != delim)  str = str + delim;
  for (i=0; i<ArraySize(a); i++)  {
    z2 = StringFind(str,delim,z1+1);
    a[i] = StringSubstr(str,z1+1,z2-z1-1);
    if (z2 >= StringLen(str)-1)   break;
    z1 = z2;
  }
  return(StringFindCount(str,delim));
}


//+------------------------------------------------------------------+
int ArrayLookupString(string str, string a[])   {
//+------------------------------------------------------------------+
 for (int i=0; i<ArraySize(a); i++)   {
   if (str == a[i])   return(i);
 }  
 return(-1);
} 

//+------------------------------------------------------------------+
double StrToNumber(string str)  {
//+------------------------------------------------------------------+
// Usage: strips all non-numeric characters out of a string, to return a numeric (double) value
//  valid numeric characters are digits 0,1,2,3,4,5,6,7,8,9, decimal point (.) and minus sign (-)
  int    dp   = -1;
  int    sgn  = 1;
  double num  = 0.0;
  for (int i=0; i<StringLen(str); i++)  {
    string s = StringSubstr(str,i,1);
    if (s == "-")  sgn = -sgn;   else
    if (s == ".")  dp = 0;       else
    if (s >= "0" && s <= "9")  {
      if (dp >= 0)  dp++;
      if (dp > 0)
        num = num + StrToInteger(s) / MathPow(10,dp);
      else
        num = num * 10 + StrToInteger(s);
    }
  }
  return(num*sgn);
}

int LoadRSvalues()  
{
  //This code courtesy of hanover. Many thanks David. You are a star.
  
  //Ccy[] holds the individual currency symbol
  //Tf[] holds the time frames
  //God knows where we go from here
  
  // Initialize array......
  for (i=0; i<8; i++)
    for (j=0; j<9; j++)
      for (k=0; k<99; k++)
         RSvalue[i][j][k] = 0;

         // Read data from Recent Strength export file into RSvalue array.......
         h = FileOpen(OutputFile,FILE_CSV|FILE_READ,'~');
         i=0; j=0; k=0;
         string prevtf = "";
         while (!FileIsEnding(h))     
         {
           StrToStringArray(FileReadString(h),arr);
           if (FileIsEnding(h))   break;
           if (arr[1] == "TF ")   
           {                                     // get ccy IDs from header record
             for (i=0; i<8; i++)  
             {
               ccy[i] = StringUpper(StringTrim(arr[i+3]));               
             }//for (i=0; i<8; i++)  
             continue;
           }//if (arr[1] == "TF ")   
           string currtf = StringUpper(StringTrimRight(arr[1]));
           j = ArrayLookupString(currtf,tf);
           if (j<0)     continue;                                    // unknown timeframe - should never happen
           if (currtf != prevtf)                                     // reset datapoint counter on change of timeframe
             k = 0;
           else
             k++;
           if (k>=99)   continue;                                    // max of 99 data points only
           for (i=0; i<8; i++)  
           {                                    // load array values for all currencies
             RSvalue[i][j][k] = StrToNumber(arr[i+3]);
             
           }//for (i=0; i<8; i++)  
           prevtf = currtf;  
         }//while (!FileIsEnding(h))     
  FileClose(h);
  return(0);
}//End int LoadRSvalues()  

void ReadHanover()
{
   //This function reads the output from the indi output file.
   LoadRSvalues();

/* Posted by hanover
If we use RSvalue[i][j][k], then
i = the currency
j = the timeframe
k = the datapoint#. Point #0 is rightmost point on the RS plot; point #1 is the second point from the right; 
point #2 is the third point from the right; and so on, up to the number of points being 
output (set by the NumPoints parameter in RS)

Hence, supposing you want to retrieve the value of the third datapoint for USD,H1, then (using the constants defined earlier) you could use the code:

double value = RSvalue[_USD][_H1][2];
*/
   //Find the strongest and weakest currency
   //Strongest
   //double s, ps;//Strongest and previous strongest value
   //double w, pw;//Weakest and previous weakest value


   //Currencies
   for (i = 0; i < ArraySize(StrongVal); i++)
   {
      StrongVal[i] = 0;//Initialize the strongest datapoint
      WeakVal[i] = 100000;//Initialize the weakest datapoint
      PrevStrongVal[i] = 0;
      PrevWeakVal[i] = 0;
   }//for (i = 0; i < ArraySize(StrongVal); i++)
   
   for (i = 0; i < ArraySize(ccy); i++)
   {
      //Timeframes
      for (j = 0; j < ArraySize(Tf); j++)
      {
         //Data point
         //Extract the timeframe - uses David's constants
         int DatapointTf;
         if (Tf[j] == "M1") DatapointTf = M1;
         if (Tf[j] == "M5") DatapointTf = M5;
         if (Tf[j] == "M15") DatapointTf = M15;
         if (Tf[j] == "M30") DatapointTf = M30;
         if (Tf[j] == "H1") DatapointTf = H1;
         if (Tf[j] == "H4") DatapointTf = H4;
         if (Tf[j] == "D1") DatapointTf = D1;
         if (Tf[j] == "W1") DatapointTf = W1;
         if (Tf[j] == "MN") DatapointTf = MN;

         //Find the strongest datapoint on the current currency and timeframe
         if (RSvalue[i, DatapointTf, 0] > StrongVal[j])
         {
            StrongestCcy[j] = ccy[i];
            StrongVal[j] = RSvalue[i, DatapointTf, 0];
            if (SlopeCandles[j] > 0)
            {
               PrevStrongVal[j] = RSvalue[i, DatapointTf, SlopeCandles[j]];
            }
         }//if (RSvalue[i, DatapointTf, 0] > StrongVal[j])
         
         //Find the weakest datapoint on the current currency and timeframe
         if (RSvalue[i, DatapointTf, 0] < WeakVal[j])
         {
            WeakestCcy[j] = ccy[i];
            WeakVal[j] = RSvalue[i, DatapointTf, 0];
            if (SlopeCandles[j] > 0)
            {
               PrevWeakVal[j] = RSvalue[i, DatapointTf, SlopeCandles[j]];
            }
         }//if (RSvalue[i, DatapointTf, 0] < WeakVal[j])

      }//for (j = 0; j < ArraySize(Tf); j++)
   }//for (i = 0; i < ArraySize(ccy); i++)
   //Alert("Strongest ", StrongestCcy[0], "  ", StrongVal[0], " Weakest ", WeakestCcy[0], "  ", WeakVal[0]);
   

   
   


}//End void ReadHanover()

double ReadStrength(string curr, string tf, int shift)
{
   /*
   Returns the strength of the individual currency referenced by the parameters:
      - curr is the currency
      - tf is the time frame
      - shift is how far back in time to look
   */

   //Extract the timeframe - uses David's constants
   int DatapointTf;
   if (tf == "M1") DatapointTf = M1;
   if (tf == "M5") DatapointTf = M5;
   if (tf == "M15") DatapointTf = M15;
   if (tf == "M30") DatapointTf = M30;
   if (tf == "H1") DatapointTf = H1;
   if (tf == "H4") DatapointTf = H4;
   if (tf == "D1") DatapointTf = D1;
   if (tf == "W1") DatapointTf = W1;
   if (tf == "MN") DatapointTf = MN;

   //Allign the curr param with David's constant
   int cc;
   if (curr == "AUD") cc = AUD;
   if (curr == "CAD") cc = CAD;
   if (curr == "CHF") cc = CHF;
   if (curr == "EUR") cc = EUR;
   if (curr == "GBP") cc = GBP;
   if (curr == "JPY") cc = JPY;
   if (curr == "NZD") cc = NZD;
   if (curr == "USD") cc = USD;
   
   return(RSvalue[cc, DatapointTf, shift]);
   
}//End double ReadStrength(string curr, string tf, int shift)

bool HanoverFilter(int type)
{
   //Returns true if the filter indicates sufficient strength/weakness in the pair.
   //Works by running through the tests and returning false if any of them fail. If all pass, the eventually
   //returns true.
   //Tests all fail if the two currencies have equal strength values

   //Read the strength values
   for (int cc = 0; cc < ArraySize(Tf); cc++)
   {
      //First filter. Compare the strength over the chosen time frames
      double strength1 = ReadStrength(Ccy1, Tf[cc], 0);
      double strength2 = ReadStrength(Ccy2, Tf[cc], 0);
      if (SlopeCandles[cc] > 0) 
      {
         double prevstrength1 = ReadStrength(Ccy1, Tf[cc], SlopeCandles[cc]);
         double prevstrength2 = ReadStrength(Ccy2, Tf[cc], SlopeCandles[cc]);   
      }//if (SlopeCandles[cc] > 0)

     
      //EA is looking to buy. 
      if (type == OP_BUY)
      {
         //First currency must be the strongest
         if (strength1 <= strength2) return(false);

         //Slope must be rising
         if (SlopeCandles[cc] > 0 && prevstrength1 >= prevstrength2) return(false);
         
         //Threshold. First currency must be above StrongThreshold. Second currency must be below WeakThreshopld
         if (StrongThreshold > 0 && WeakThreshold > 0)
         {
            if (strength1 < StrongThreshold || strength2 > WeakThreshold) return(false);
         }//if (StrongThreshold > 0 && WeakThreshold > 0)
         
      }//if (type == OP_BUY)
      
      //EA is looking to sell. 
      if (type == OP_SELL)
      {
         //First currency must be the weakest
         if (strength1 >= strength2) return(false);

         //Slope must be falling
         if (SlopeCandles[cc] > 0 && prevstrength1 <= prevstrength2) return(false);
         
         //Threshold. First currency must be below WeakThreshold. Second currency must be above StrongThreshopld
         if (StrongThreshold > 0 && WeakThreshold > 0)
         {
            if (strength1 > WeakThreshold || strength2 < StrongThreshold) return(false);
         }//if (StrongThreshold > 0 && WeakThreshold > 0)

      }//if (type == OP_BUY)
      
      
         
         
         
   }//for (int cc = 0; cc < ArraySize(Tf); cc++)

   

   //Got this far, so all tests have passed.
   return(true);

}//End bool HanoverFilter()


//End Hanover module
////////////////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////////////////
//Central Bank Intervention module

bool CentralBankInterventionModule()
{
   /*
   Called from start() if UseCBI is enabled.
   Monitors the TickTable array and reacts to the movement in the market being >= the Threshold.
   The circular TickTable code is provided by Carsten. Many thanks Carsten. You are a star.
   Function returns true if all actions succeed or none are necessary, and false to force the bot to keep on retrying
   */

   //Store the latest quote in TickTable
   StoreQuote();

   if (is_filled == 0) // table not full yet, so nothing to do
   { 
      return(true);
   }//if (is_filled == 0)

   double take, stop, price, type;
   string direction;
   bool result;
   int tries;
   
   // table is full, now we can check for the big moves
   if (TickDiff > Threshold) 
   {
      TakingEmergencyAction = true;//Used in SendSingleTrade to create a mahoosive slippage allowance
      
      //Calculate the direction of the move
      direction = down;
      if (TickTable[tc] > TickTable[tc + 1] ) direction = up;
      
      // The price difference between the latest and the first entry in
      // our table is above the threshold, so take action.

      /////////////////////////////////////////////////////////////////////////////////////////////////
      //Close trade
      if (CloseOnCBI && !TradesClosed && OpenTrades > 0)
      {
         result = false;
         if (direction == down)
         {
            tries = 0;
            while (!result)
            {
               result = CbiCloseTrades(OP_BUY);
               if (result) TradesClosed = true;
               tries++;
               if (tries == 20) return(true);
            }//while (!result)            
         }//if (direction == down)
         
         
         if (direction == up)
         {
            tries = 0;
            while (!result)
            {
               result = CbiCloseTrades(OP_SELL);
               if (result) TradesClosed = true;
               tries++;
               if (tries == 20) return(true);
            }//while (!result)            
         }//if (direction == ip)
      }//if (CloseOnCBI)
      /////////////////////////////////////////////////////////////////////////////////////////////////
      
      /////////////////////////////////////////////////////////////////////////////////////////////////
      //Hedge an existing trade
      if (HedgeOnCBI && !HedgeSent && TicketNo > -1)
      {
         result = false;
         if (direction == down)
         {
            tries = 0;
            while (!result)
            {
               result = CbiHedging(OP_BUY);//Long trades need hedging short
               if (result) HedgeSent = true;
               tries++;
               if (tries == 20) return(true);
            }//while (!result)            
         }//if (direction == down)
         
         
         if (direction == up)
         {
            tries = 0;
            while (!result)
            {
               result = CbiHedging(OP_SELL);//Short trades need hedging long
               if (result) HedgeSent = true;
               tries++;
               if (tries == 20) return(true);
            }//while (!result)            
         }//if (direction == ip)         
      }//if (HedgeOnCBI)
      /////////////////////////////////////////////////////////////////////////////////////////////////
      
      
      /////////////////////////////////////////////////////////////////////////////////////////////////
      //Take a new trade
      if (TradeOnCBI && !TradeSent)
      {         
         if (direction == up)
         {
            type = OP_BUY;
            RefreshRates();
            price = Ask;
            if (TradeOnCbiTP > 0) take = NormalizeDouble(Ask + (TradeOnCbiTP * Point), Digits);
            if (TradeOnCbiSL > 0) stop = NormalizeDouble(Ask - (TradeOnCbiSL * Point), Digits);            
         }//if (direction == up)
         
         if (direction == down)
         {
            type = OP_SELL;
            RefreshRates();
            price = Bid;
            if (TradeOnCbiTP > 0) take = NormalizeDouble(Bid - (TradeOnCbiTP * Point), Digits);
            if (TradeOnCbiSL > 0) stop = NormalizeDouble(Bid + (TradeOnCbiSL * Point), Digits);            
         }//if (direction == up)
         result = SendSingleTrade(type, TradeComment, Lot, price, stop, take);
         if (result) 
         {
            TradeSent = true;
         }//if (result) 
         
         if (!result) 
         {
            return(false);
         }//if (result) 
         
      }//if (TradeOnCBI)
      /////////////////////////////////////////////////////////////////////////////////////////////////
      
      
      
      
   }//if (TickDiff > Threshold) 
   else 
   {   
      TakingEmergencyAction = false;
      TradeSent = false;
      HedgeSent = false;
      TradesClosed = false;
   }//else 


   //Got this far, so everything has worked as required
   return(true);

}//End bool CentralBankInterventionModule()

void StoreQuote()
{

   // fill the current tick value into the table
   TickTable[tc] = Bid;

   if (is_filled == 0) // table not full yet
   { 
      fill_check_counter += 1;
      if (fill_check_counter == TableSize) is_filled = 1;
   }//if (is_filled == 0)
   else 
   {
      TickDiff = MathAbs(TickTable[(tc + 1) % TableSize] - TickTable[tc]) * PipMultiplier;
   }//else   
      
      
   // increment the counter
   tc += 1;
   tc = tc % TableSize;// keeps tc within TableSize

}//End void StoreQuote()

bool CbiCloseTrades(int type)
{
   bool success = true;
   
   if (OrdersTotal() == 0) return(true);
   
   for (int cc = OrdersTotal() - 1; cc >= 0; cc--)
   {
      if (!OrderSelect(cc, SELECT_BY_POS) ) continue;
      if (OrderMagicNumber() != MagicNumber) continue;
      if (OrderSymbol() != Symbol() ) continue;
      while(IsTradeContextBusy()) Sleep(100);
      if (OrderType() == type) bool result = OrderClose(OrderTicket(), OrderLots(), OrderClosePrice(), 1000, CLR_NONE);
      if (result) cc++;
      if (!result) success = false;      
   }//for (int cc = OrdersTotal() - 1; cc >= 0; cc--)
   
   return(success);

}//End bool CbiCloseTrades(int type)


bool CbiHedging(int type)
{
   //Opens an opposite direction hedge trade to that of the passed param
   bool success = true;
   bool result;
   int HedgeType = OP_SELL;
   if (type == OP_SELL) HedgeType = OP_BUY;
   
   if (OrdersTotal() == 0) return(true);
   
   for (int cc = 0; cc <= OrdersTotal() - 1; cc++)
   {
      if (!OrderSelect(cc, SELECT_BY_POS) ) continue;
      if (OrderMagicNumber() != MagicNumber) continue;
      if (OrderSymbol() != Symbol() ) continue;
      while(IsTradeContextBusy()) Sleep(100);

      //Check to see if the trade is already hedged.
      bool hedged = IsTradeAlreadyHedged(cc);
      if (hedged) 
      {
         //TicketNo is set in CountOpenTrades(). Reset the selected trade in case the intervening code leaves it unselected.
         OrderSelect(TicketNo, SELECT_BY_TICKET, MODE_TRADES);         
      }//if (IsTradeAlreadyHedged(index)) 

      if (!hedged)
      {
         if (OrderType() == type) result = SetupHedgeTrade(HedgeType);
         if (!result) success = false;      
      }//if (!hedged)
      
   }//for (int cc = OrdersTotal() - 1; cc >= 0; cc--)
   
   return(success);



}//End bool CbiHedging(int type)

bool SetupHedgeTrade(int type)
{
   //Order that needs hedging is already selected. This function sets up and sends the hedge trade
   
   bool result = false;
   int tries = 0;
   double SendLots;
   double price;

   SendLots = OrderLots() * CbiHedgeLotMultiplier;
   
   
   
   if (type == OP_SELL) 
   {
      //Check the trade does need hedging
      if (OrderProfit() > 0 && OrderStopLoss() > OrderOpenPrice() ) return(true);//No need to hedge a safe trade
      RefreshRates();
      price = Bid;
   }//if (type == OP_SELL) 
   
   if (type == OP_BUY) 
   {
      //Check the trade does need hedging
      if (OrderProfit() > 0 && OrderStopLoss() < OrderOpenPrice() ) return(true);//No need to hedge a safe trade
      RefreshRates();
      price = Ask;
   }//if (type == OP_BUY) 
   
   while (IsTradeContextBusy() ) Sleep(100);
   int tn = OrderTicket();//Need this to reselect the trade to remove the tp and sl from the trade
   while (!result)
   {
      result = SendSingleTrade(type, TradeComment, SendLots, price, 0, 0);
      //Remove existing tp/sl from the hedged trade. I will tidy this up later
      if (result) 
      {
         HedgingInProgress = true;
         OrderSelect(tn, SELECT_BY_TICKET);
         if (OrderTakeProfit() > 0) 
         {
            while (IsTradeContextBusy() ) Sleep(100);            
            OrderModify(tn, OrderOpenPrice(), OrderStopLoss(), 0, OrderExpiration(), CLR_NONE);
         }//if (OrderTakeProfit() > 0) 
         
         if (OrderStopLoss() > 0) 
         {
            if (OrderStopLoss() > 0) OrderModify(tn, OrderOpenPrice(), 0, OrderTakeProfit(), OrderExpiration(), CLR_NONE);
         }//if (OrderStopLoss() > 0)             
      }//if (result) 
      
      tries++;
      if (tries == 20) result = true;      
   }//while (!result)
   
   
   return(result);
   
}//bool SetupHedgeTrade()

bool IsTradeAlreadyHedged(int index)
{

   /*
   Trade will already be hedged if:
      - there is an opposite direction trade open
      - the opp trade has a lot size x HedgeLotsMultiplier
   */
   
   //Alread at the end of the trade loop?
   if (index == OrdersTotal() - 1) return(false);
   
   //Need to know the order type and lot size
   int type = OrderType();
   double LotSize = OrderLots();
   
   //Loop through the remaining trades to find a hedge. Reselect original trade and teturn true if found
   for (int cc = index + 1; cc < OrdersTotal(); cc++)
   {
      if (!OrderSelect(cc, SELECT_BY_POS) ) continue;
      if (OrderSymbol() != Symbol() ) continue;
      if (OrderMagicNumber() != MagicNumber) continue;
      
      //All EA belonging conditions satisfied, so examine the trades
      if (type == OP_BUY && OrderType() == OP_SELL && OrderLots() == LotSize * CbiHedgeLotMultiplier) 
      {
         //TicketNo is set in CountOpenTrades(). Reset the selected trade.
         OrderSelect(TicketNo, SELECT_BY_TICKET, MODE_TRADES);   
         return(true);//Is a hedge
      }//if (type == OP_BUY && OrderType() == OP_SELL && OrderLots() == LotSize * 2) 
      
      if (type == OP_SELL && OrderType() == OP_BUY && OrderLots() == LotSize * CbiHedgeLotMultiplier) 
      {
         //TicketNo is set in CountOpenTrades(). Reset the selected trade.
         OrderSelect(TicketNo, SELECT_BY_TICKET, MODE_TRADES);   
         return(true);//Is a hedge
      }//if (type == OP_SELL && OrderType() == OP_BUY && OrderLots() == LotSize * 2) 
      
   }//for (int cc = index + 1); cc < OrdersTotal(); cc++)
   
   
   //TicketNo is set in CountOpenTrades(). Reset the selected trade.
   OrderSelect(TicketNo, SELECT_BY_TICKET, MODE_TRADES);
   
   //Got this far, so trade is not already hedged
   return(false);

}//End bool IsTradeAlreadyHedged(int index)



//End Central Bank Intervention module
////////////////////////////////////////////////////////////////////////////////////////////////

double CalculateTradeProfitInPips()
{
   //This function returns the profit/loss of an individual trade in pips. The function is called from
   //within CountTrades(), so the trade is already selected

   double Pips;
   
   //This returns Pips as a whole number
   Pips = (OrderProfit() / OrderLots()) / MarketInfo(OrderSymbol(),MODE_TICKVALUE);

   double digits = MarketInfo(OrderSymbol(), MODE_DIGITS);
   int multiplier;
   if (digits == 2) multiplier = 10;
   if (digits == 3) multiplier = 100;
   if (digits == 4) multiplier = 1000;
   if (digits == 5) multiplier = 10000;
   
   //This returns Pips as a decimal number i.e. Pips * Point
   //Pips = (OrderProfit() / OrderLots()) / MarketInfo(OrderSymbol(),MODE_TICKVALUE) / multiplier;

   return(Pips);

}//double CalculateTradeProfitInPips()

/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Round numbers module
void GetNextRoundNumbers()
{
   //Finds the nearest big numbers to the market price.
   //Saves these in RoundNumberHigh and RoundNumberLow, BigNumberHigh and BigNumberLow.
   //George provided this code, so thanks again George.
   
   int multiplier;

   if(Digits == 2 || Digits == 4) multiplier = 1;
   if(Digits == 3 || Digits == 5) multiplier = 10;
   if(Digits == 6) multiplier = 100;   
   if(Digits == 7) multiplier = 1000;   
   RefreshRates();
   
   double price = High[0];
   RoundNumberHigh = GetNext00(price, multiplier);//Next 'round' number (eg 1.3400)
   RoundNumberLow  = GetPrev00(price, multiplier);//Previous 'round' number (eg 1.3300)
   BigNumberHigh   = GetNext000(price, multiplier);//Next 'big' number (eg 1.4000)
   BigNumberLow    = GetPrev000(price, multiplier);//Previous  'big' number (eg 1.3000)
   

}//End void GetNextRoundNumbers()

double GetNext00(double price, int multiplier) 
{
   
   double tmp = price - MathMod(price,100*Point*multiplier);
   tmp = tmp + 100*Point*multiplier;
   return (tmp);

}//End double GetNext00(double price) 

double GetPrev00(double price, int multiplier) 
{
   double tmp = price - MathMod(price,100*Point*multiplier);
   return (tmp);

}//End double GetPrev00(double price) 

double GetNext000(double price, int multiplier) 
{
   double tmp = price - MathMod(price,1000*Point*multiplier);
   tmp = tmp + 1000*Point*multiplier;
   return (tmp);

}//End double GetNext000(double price) 

double GetPrev000(double price, int multiplier) 
{
   
   double tmp = price - MathMod(price,1000*Point*multiplier);
   return (tmp);

}//End double GetPrev000(double price) 



//End //Round numbers module
/////////////////////////////////////////////////////////////////////////////////////////////////////////////

//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
int start()
{
//----

   
      //Find open trades.
   CountOpenTrades();

   //Reset various bools
   if (OpenTrades == 0)
   {
      //CBI
      TakingEmergencyAction = false;
      TradeSent = false;
      HedgeSent = false;
      TradesClosed = false;
      //Hedging and Recovery
      HedgingInProgress = false;
   }//if (OpenTrades > 0)


   //Monitor an existing pending trade line
   if (ObjectFind(pendingpriceline) > -1)
   {
      color col = ObjectGet(pendingpriceline, OBJPROP_COLOR);
      
      if (col == BuyLineColour) HasBuyFilled();
      if (col == SellLineColour) HasSellFilled();
   }//if (ObjectFind(pendingpriceline) > -1)

   //There is a call to gnrn in init() so the bot knows what they are at the first tick. Put the next call
   //here so that the pending trade line is not moved if the next tick would trigger the trade - need to
   //check the trigger first.
   GetNextRoundNumbers();


   /*
   People get twitchy when reading the code being removed from the ex4 file warning, so here is a neat method of
   turning off a function without deleting it, just in case you change your mind and want it later. I actually call
   CalculateTradeProfitInPips() from within CountOpenTrades() and include it here merely as an example.
   */
   if (TurnOff == 1) CalculateTradeProfitInPips();//TurnOff is never 1, so the function is not called
   
   if (OrdersTotal() == 0)
   {
      TicketNo = -1;
      ForceTradeClosure = false;
   }//if (OrdersTotal() == 0)

   //Central Bank Intervention module
   if (UseCBI) 
   {
      int tries;
      bool ok = false;
      while (!ok)
      {
         ok = CentralBankInterventionModule();         
         tries++;
         if (tries == 20) ok = true;
      }//while (!ok)         
   }//if (UseCBI) 

   if (ForceTradeClosure) 
   {
      CloseAllTrades();
      return;
   }//if (ForceTradeClosure) 

   
   if (UseHanover)
   {
      //Read the indi once a minute
      if (ReadBars != iBars(NULL, PERIOD_M1) && UseHanover)
      {
         ReadBars = iBars(NULL, PERIOD_M1);
         ReadHanover();
      }//if (ReadBars != iBars(NULL, PERIOD_M1)
   }//if (UseHanover)
   
   //Daily results so far - they work on what in in the history tab, so users need warning that
   //what they see displayed on screen depends on that.   
   static int OldHistoryTotal;
   if (OrdersHistoryTotal() != OldHistoryTotal)
   {
      CalculateDailyResult();//Does no harm to have a recalc from time to time
      OldHistoryTotal = OrdersHistoryTotal();
   }//if (OrdersHistoryTotal() != OldHistoryTotal)
   
   
   ReadIndicatorValues();

   //Delete orphaned tp/sl lines
   static int M15Bars;
   if (M15Bars != iBars(NULL, PERIOD_M15) )
   {
      M15Bars = iBars(NULL, PERIOD_M15);
      DeleteOrphanTpSlLines();
   }//if (M15Bars != iBars(NULL, PERIOD_M15)
   
      
   ///////////////////////////////////////////////////////////////////////////////////////////////

   //Reset various bools
   if (OpenTrades == 0)
   {
      //CBI
      TakingEmergencyAction = false;
      TradeSent = false;
      HedgeSent = false;
      TradesClosed = false;
      //Hedging and Recovery
      HedgingInProgress = false;
   }//if (OpenTrades > 0)


   //Hedging. This might need removing
   if (HedgingInProgress)
   {
      if (upl >= 0) 
      {
         CloseAllTrades();
      }//if (upl <= HedgeStopLoss && HedgeStopLoss != 0) 
      
      if (ForceTradeClosure) return;
   }//if (UseHedging)

   ///////////////////////////////////////////////////////////////////////////////////////////////
   
 
   /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
   //Trading times
   bool TradeTimeOk = CheckTradingTimes();
   if (!TradeTimeOk)
   {
      Comment("Outside trading hours\nstart_hourm-end_hourm: ", start_hourm, "-",end_hourm, "\nstart_houre-end_houre: ", start_houre, "-",end_houre);
      return;
   }//if (hour < start_hourm)
   /////////////////////////////////////////////////////////////////////////////////////////////////////////////////

   //Available margin filters
   EnoughMargin = true;//For user display
   MarginMessage = "";
   if (UseScoobsMarginCheck && OpenTrades > 0)
   {
      if(AccountMargin() > (AccountFreeMargin()/100)) 
      {
         MarginMessage = "There is insufficient margin to allow trading. You might want to turn off the UseScoobsMarginCheck input.";
         DisplayUserFeedback();
         return;
      }//if(AccountMargin() > (AccountFreeMargin()/100)) 
      
   }//if (UseScoobsMarginCheck)


   if (UseForexKiwi && AccountMargin() > 0)
   {
      
      double ml = NormalizeDouble(AccountEquity() / AccountMargin() * 100, 2);
      if (ml < FkMinimumMarginPercent)
      {
         MarginMessage = StringConcatenate("There is insufficient margin percent to allow trading. ", DoubleToStr(ml, 2), "%");
         DisplayUserFeedback();
         return;
      }//if (ml < FkMinimumMarginPercent)
      
   }//if (UseForexKiwi && AccountMargin() > 0)

   ///////////////////////////////////////////////////////////////////////////////////////////////         
   //Trading
      
   if (!StopTrading)
   {
      //Trend detection      
      if (UseTrendDetection) TrendDetectionModule();
      if (!UseTrendDetection && RisingTrend) OverallTrend = up;
      if (!UseTrendDetection && FallingTrend) OverallTrend = down;
      
   
      LookForTradingOpportunities();
   }//if (TicketNo == -1)
   ///////////////////////////////////////////////////////////////////////////////////////////////      

   DisplayUserFeedback();
   
//----
   return(0);
}
//+------------------------------------------------------------------+

